/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import com.l2fprod.common.swing.JTaskPaneGroup;
import com.l2fprod.common.swing.JTaskPanel;
import explorer.data.Common;
import explorer.data.DataManager;
import explorer.data.OptionsExplorer;
import explorer.data.SrcObserver;
import explorer.data.ViewManager;
import explorer.windows.w2D.icview.ICVSampling;
import explorer.windows.w2D.utils.ContribDialog;
import explorer.windows.w2D.utils.HelpContentDialog;
import explorer.windows.w2D.utils.Progres;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import lib3d4j.data.Source;
import lib3d4j.international.Messages;

public class Lateral
extends JFrame
implements SrcObserver,
Observer {
    private boolean srcLoaded = false;
    private Map<String, JTaskPaneGroup> icviews = new HashMap<String, JTaskPaneGroup>();
    private Map<String, List<ICViewInitialState>> icvgroups = new HashMap<String, List<ICViewInitialState>>();
    private JPanel contentPane;
    private BorderLayout borderLayout1 = new BorderLayout();
    private Common general;
    private JTaskPanel taskPane = new JTaskPanel();
    private JMenuBar mnu = new JMenuBar();
    private JMenu mnuFile;
    protected JMenuItem mnuFileLoadFileNew;
    protected JMenuItem mnuFileLoadOnlineNew;
    protected JMenuItem mnuFileLoadFileExt;
    protected JMenuItem mnuFileLoadOnlineExt;
    protected JMenuItem mnuFileLangage;
    protected JMenuItem mnuFileData;
    protected JMenu mnuFileLoadACP;
    protected JMenuItem mnuFileLoadFichierPrimitives;
    protected JMenuItem mnuFileLoadACPLoad;
    protected JMenuItem mnuFileLoadACPProlog;
    protected JMenuItem mnuFileLoadACPSeuil;
    protected JMenuItem mnuFileSimil;
    protected JMenuItem mnuFileDist;
    protected JMenuItem mnuFileLoadPoint3D;
    protected JMenuItem mnuFileLoadScript;
    protected JMenuItem mnuFileToolImportData;
    protected JMenuItem mnuFileExit;
    protected JMenuItem mnuFileSocketInput;
    protected JMenuItem mnuFileSaveProject;
    protected JMenuItem mnuFileLoadProject;
    private JMenu mnuPerspective;
    private JMenu mnuTools;
    protected JMenuItem mnuToolsLangage;
    protected JMenuItem mnuPersMDSMetrique;
    protected JMenuItem mnuToolsMDS;
    protected JMenuItem mnuPersACP;
    protected JMenuItem mnuPersView;
    protected JMenuItem mnuPersSVM;
    protected JMenuItem mnuPersClassif;
    protected JMenuItem mnuPersMosaic;
    protected JMenuItem mnuToolsIte;
    protected JMenuItem mnuToolsScript;
    protected JMenuItem mnuToolsCamera;
    protected JCheckBoxMenuItem mnuToolsFromImages;
    protected JMenuItem mnuToolsCrop;
    protected JMenuItem mnuToolsDimensionsTravel;
    protected JCheckBoxMenuItem mnuToolsWiimote;
    protected JMenuItem mnuToolsClass;
    protected JMenuItem[] fileHistory;
    protected JMenuItem mnuToolsOptions;
    protected JMenuItem mnuToolsDistorsions;
    protected JMenu mnuHelp;
    protected JMenuItem mnuHelpContent;
    protected JMenuItem mnuHelpContribs;
    private LateralActionListener lal;
    private Progres jProgres = null;
    private JLabel jEtat = null;
    private JLabel jStatus = null;
    private boolean multiSrcMode;
    private JMenuItem mnuToolsSampling;

    public Lateral(Common g) {
        try {
            this.setDefaultCloseOperation(0);
            this.general = g;
            this.jbInit();
            OptionsExplorer.getSingleton().addObserver(this);
            this.applyOptions();
            ViewManager.getSingleton().addSrcObserver(this);
            this.setLocation(0, 0);
            this.general.setLateral(this);
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addICView(JPanel icv, String title) {
        JTaskPaneGroup tmp = new JTaskPaneGroup();
        tmp.add(icv);
        tmp.setTitle(icv.getName());
        this.icviews.put(title, tmp);
    }

    public void addICVGroup(String group, List<ICViewInitialState> views) {
        this.icvgroups.put(group, views);
    }

    public void setCurrentICVGroup(String group) {
        List<ICViewInitialState> views = this.icvgroups.get(group);
        if (views != null) {
            this.taskPane.removeAll();
            for (ICViewInitialState is : views) {
                JTaskPaneGroup tpg = this.icviews.get(is.getTitle());
                tpg.setExpanded(is.isExpanded());
                this.taskPane.add(tpg);
            }
        }
        this.pack();
    }

    public void setICViewVisible(String title, boolean visible) {
        JTaskPaneGroup tpg = this.icviews.get(title);
        if (tpg != null) {
            tpg.setExpanded(visible);
        }
    }

    public void chargerFichierDemarrage(String fileName, int type) {
        System.out.println(fileName);
        this.general.load(type, fileName);
    }

    private void jbInit() throws Exception {
        this.lal = new LateralActionListener(this, this.general);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        Dimension tailleEcran = Toolkit.getDefaultToolkit().getScreenSize();
        int hauteur = (int)tailleEcran.getHeight();
        int largeur = (int)tailleEcran.getWidth();
        this.setSize(280, hauteur - 30);
        this.setTitle(Messages.getString("lateral_title"));
        this.contentPane.add((Component)this.taskPane, "Center");
        this.addMenu();
        this.setJMenuBar(this.mnu);
        JPanel pnlM = new JPanel(new GridLayout(0, 1));
        pnlM.setBackground(this.taskPane.getBackground());
        pnlM.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.taskPane.getBackground()));
        this.jStatus = new JLabel();
        pnlM.add(this.jStatus);
        this.jProgres = new Progres();
        this.jProgres.setPreferredSize(new Dimension(this.getWidth() - 6, 20));
        pnlM.add(this.jProgres);
        this.jEtat = new JLabel();
        this.jEtat.setBackground(Color.gray);
        this.jEtat.setPreferredSize(new Dimension(this.getWidth() - 8, 20));
        pnlM.add(this.jEtat);
        this.contentPane.add((Component)pnlM, "South");
    }

    public void setACPTPG() {
        this.setCurrentICVGroup("AttrVal");
    }

    public void setMDSMetriqueTPG() {
        this.setCurrentICVGroup("Distance");
    }

    public void setCropTPG() {
        this.setCurrentICVGroup("CropBox");
    }

    public void setDimensionsTravelTPG() {
        this.setCurrentICVGroup("DimensionTravel");
    }

    public void setVisuTPG() {
        this.setCurrentICVGroup("3DSpace");
    }

    public void setClassifTPG() {
        this.setCurrentICVGroup("Classification");
    }

    public void setIteTPG() {
        this.setCurrentICVGroup("Interaction");
    }

    public void setSVMTPG() {
        this.setCurrentICVGroup("SVM");
    }

    private void addMenu() {
        this.mnuFile = new JMenu(Messages.getString("files"));
        this.mnu.add(this.mnuFile);
        this.mnuFileLoadFileNew = new JMenuItem(Messages.getString("load_file_new"));
        this.mnuFileLoadFileNew.addActionListener(this.lal);
        this.mnuFile.add(this.mnuFileLoadFileNew);
        this.mnuFileLoadOnlineNew = new JMenuItem(Messages.getString("load_online_new"));
        this.mnuFileLoadOnlineNew.setForeground(Color.MAGENTA);
        this.mnuFileLoadOnlineNew.addActionListener(this.lal);
        this.mnuFile.add(this.mnuFileLoadOnlineNew);
        this.mnuFile.add(new JSeparator());
        this.mnuFileLoadFileExt = new JMenuItem(Messages.getString("load_file"));
        this.mnuFileLoadFileExt.setBackground(Color.cyan);
        this.mnuFileLoadFileExt.addActionListener(this.lal);
        this.mnuFileLoadFileExt.setVisible(false);
        this.mnuFile.add(this.mnuFileLoadFileExt);
        this.mnuFile.add(new JSeparator());
        this.mnuFileLoadOnlineExt = new JMenuItem(Messages.getString("load_online"));
        this.mnuFileLoadOnlineExt.setBackground(Color.cyan);
        this.mnuFileLoadOnlineExt.setForeground(Color.MAGENTA);
        this.mnuFileLoadOnlineExt.addActionListener(this.lal);
        this.mnuFileLoadOnlineExt.setVisible(false);
        this.mnuFile.add(this.mnuFileLoadOnlineExt);
        this.mnuFileLoadScript = new JMenuItem(Messages.getString("load_script"));
        this.mnuFileLoadScript.addActionListener(this.lal);
        this.mnuFileSaveProject = new JMenuItem(Messages.getString("save_project"));
        this.mnuFileSaveProject.addActionListener(this.lal);
        this.mnuFile.add(this.mnuFileSaveProject);
        this.mnuFileLoadProject = new JMenuItem(Messages.getString("load_project"));
        this.mnuFileLoadProject.addActionListener(this.lal);
        this.mnuFile.add(this.mnuFileLoadProject);
        this.mnuFile.add(new JSeparator());
        this.mnuFileToolImportData = new JMenuItem(Messages.getString("load_tool_import_data"));
        this.mnuFileToolImportData.addActionListener(this.lal);
        this.mnuFile.add(this.mnuFileToolImportData);
        this.mnuFile.add(new JSeparator());
        this.fileHistory = this.general.fileHistory.getMenuItems();
        int i = 0;
        while (i < this.fileHistory.length) {
            this.fileHistory[i].addActionListener(this.lal);
            this.mnuFile.add(this.fileHistory[i]);
            ++i;
        }
        this.mnuFile.add(new JSeparator());
        this.mnuFile.add(new JSeparator());
        this.mnuFileExit = new JMenuItem(Messages.getString("exit"));
        this.mnuFileExit.addActionListener(this.lal);
        this.mnuFile.add(this.mnuFileExit);
        this.mnuPerspective = new JMenu(Messages.getString("perspective"));
        this.mnu.add(this.mnuPerspective);
        this.mnuPersACP = new JMenuItem(Messages.getString("acp"));
        this.mnuPersACP.addActionListener(this.lal);
        this.mnuPerspective.add(this.mnuPersACP);
        this.mnuPersMDSMetrique = new JMenuItem(Messages.getString("metric_mds"));
        this.mnuPersMDSMetrique.addActionListener(this.lal);
        this.mnuPerspective.add(this.mnuPersMDSMetrique);
        this.mnuPerspective.add(new JSeparator());
        this.mnuPersView = new JMenuItem(Messages.getString("visualization"));
        this.mnuPersView.addActionListener(this.lal);
        this.mnuPerspective.add(this.mnuPersView);
        this.mnuPerspective.add(new JSeparator());
        this.mnuPersClassif = new JMenuItem(Messages.getString("classification"));
        this.mnuPersClassif.addActionListener(this.lal);
        this.mnuPerspective.add(this.mnuPersClassif);
        this.mnuPersSVM = new JMenuItem(Messages.getString("svm"));
        this.mnuPersSVM.addActionListener(this.lal);
        this.mnuPerspective.add(this.mnuPersSVM);
        this.mnuPerspective.add(new JSeparator());
        this.mnuPersMosaic = new JMenuItem(Messages.getString("mosaic"));
        this.mnuPersMosaic.addActionListener(this.lal);
        this.mnuPerspective.add(this.mnuPersMosaic);
        this.mnuTools = new JMenu(Messages.getString("tools"));
        this.mnu.add(this.mnuTools);
        this.mnuToolsCrop = new JMenuItem(Messages.getString("crop"));
        this.mnuToolsCrop.addActionListener(this.lal);
        this.mnuTools.add(this.mnuToolsCrop);
        this.mnuTools.add(new JSeparator());
        this.mnuToolsSampling = new JMenuItem(Messages.getString("sampling"));
        this.mnuToolsSampling.addActionListener(this.lal);
        this.mnuTools.add(this.mnuToolsSampling);
        this.mnuTools.add(new JSeparator());
        this.mnuToolsIte = new JMenuItem(Messages.getString("interaction"));
        this.mnuToolsIte.addActionListener(this.lal);
        this.mnuTools.add(this.mnuToolsIte);
        this.mnuToolsDimensionsTravel = new JMenuItem(Messages.getString("dimensions_travel"));
        this.mnuToolsDimensionsTravel.addActionListener(this.lal);
        this.mnuTools.add(this.mnuToolsDimensionsTravel);
        this.mnuTools.add(new JSeparator());
        this.mnuToolsFromImages = new JCheckBoxMenuItem(Messages.getString("fromimages"), false);
        this.mnuToolsFromImages.addActionListener(this.lal);
        this.mnuToolsOptions = new JMenuItem(Messages.getString("options_title"));
        this.mnuToolsOptions.addActionListener(this.lal);
        this.mnuTools.add(this.mnuToolsOptions);
        this.mnu.add(Box.createHorizontalGlue());
        this.mnuHelp = new JMenu(Messages.getString("help"));
        this.mnuHelpContent = new JMenuItem(Messages.getString("helpcontent"));
        this.mnuHelpContent.addActionListener(this.lal);
        this.mnuHelp.add(this.mnuHelpContent);
        this.mnuHelpContribs = new JMenuItem(Messages.getString("contribs"));
        this.mnuHelpContribs.addActionListener(this.lal);
        this.mnuHelp.add(this.mnuHelpContribs);
        this.mnu.add(this.mnuHelp);
    }

    public void setStatusText(String s) {
        this.jStatus.setText(s);
    }

    public void setProgressOn(String s, int val) {
        this.jProgres.turnOn(s, val);
    }

    public void setProgressOff() {
        this.jProgres.turnOff();
    }

    public void setProgressInc(String s) {
        this.jProgres.inconnu(s);
    }

    public void setProgresMin(int i) {
        this.jProgres.setMinimum(i);
    }

    public void setProgresMax(int i) {
        this.jProgres.setMaximum(i);
    }

    public void setProgressString(String s) {
        this.jProgres.setString(s);
    }

    public void setProgressStringPainted(boolean b) {
        this.jProgres.setStringPainted(b);
    }

    public void setProgressReDraw() {
        this.jProgres.reDraw();
    }

    public void setProgressVal(int val) {
        this.jProgres.setValue(val);
        this.paintProgresImmediately(0, 0, 1000, 1000);
    }

    public void paintProgresImmediately(int a, int b, int c, int d) {
        this.jProgres.paintImmediately(a, b, c, d);
    }

    public void paintEtatImmediately(int a, int b, int c, int d) {
        this.jEtat.paintImmediately(a, b, c, d);
    }

    public void setEtatText(String s) {
        this.jEtat.setText(s);
        this.paintEtatImmediately(0, 0, 1000, 1000);
    }

    private void applyOptions() {
        this.multiSrcMode = this.general.getOptions().isMultiSource();
        if (this.srcLoaded) {
            this.mnuFileLoadFileExt.setVisible(this.multiSrcMode);
            this.mnuFileLoadOnlineExt.setVisible(this.multiSrcMode);
        }
    }

    @Override
    public void activeSrcChanged(Source src) {
        if (!this.srcLoaded && this.multiSrcMode) {
            this.mnuFileLoadFileExt.setVisible(true);
            this.mnuFileLoadOnlineExt.setVisible(true);
            this.srcLoaded = true;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof OptionsExplorer) {
            this.applyOptions();
        }
    }

    public static class ICViewInitialState {
        private String title;
        private boolean expanded;

        public ICViewInitialState(String title, boolean expanded) {
            this.title = title;
            this.expanded = expanded;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isExpanded() {
            return this.expanded;
        }
    }

    class LateralActionListener
    implements ActionListener {
        private Lateral parent;
        private Common c;

        public LateralActionListener(Lateral parent, Common c) {
            this.parent = parent;
            this.c = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == Lateral.this.mnuFileLoadFileExt) {
                this.c.load(false);
            } else if (source == Lateral.this.mnuFileLoadOnlineExt) {
                this.c.load(true);
            } else if (source == Lateral.this.mnuFileLoadFileNew) {
                if (!Lateral.this.multiSrcMode || !Lateral.this.srcLoaded || JOptionPane.showConfirmDialog(this.parent, Messages.getString("new_project_text"), Messages.getString("new_project_text"), 0) == 0) {
                    DataManager.getSingleton().reset();
                    Common.getSingleton().reinitialiserParametres();
                    this.c.load(false);
                }
            } else if (source == Lateral.this.mnuFileLoadOnlineNew) {
                if (!Lateral.this.multiSrcMode || !Lateral.this.srcLoaded || JOptionPane.showConfirmDialog(this.parent, Messages.getString("new_project_text"), Messages.getString("new_project_text"), 0) == 0) {
                    DataManager.getSingleton().reset();
                    Common.getSingleton().reinitialiserParametres();
                    this.c.load(true);
                }
            } else if (source == Lateral.this.mnuToolsOptions) {
                Lateral.this.general.getOptionsPanel().setVisible(true);
                Lateral.this.applyOptions();
            } else if (source == Lateral.this.mnuToolsScript) {
                Lateral.this.general.getScript().setVisible(true);
            } else if (source == Lateral.this.mnuFileLoadFichierPrimitives) {
                URL u = this.c.getParam().getCurrentPath();
                String path = null;
                path = u.getProtocol().equals("file") ? u.getPath() : System.getProperty("user.dir");
                int returnVal = 0;
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File(path));
                chooser.changeToParentDirectory();
                returnVal = chooser.showOpenDialog(null);
                this.c.setCheminVisuPrimitives(chooser.getSelectedFile().getAbsolutePath());
                this.c.getIterationsDialog().setVisible(true);
            } else if (source != Lateral.this.mnuFileData) {
                if (source == Lateral.this.mnuFileLoadScript) {
                    this.c.newLoadScript();
                } else if (source == Lateral.this.mnuFileSaveProject) {
                    this.c.saveProject();
                } else if (source == Lateral.this.mnuFileLoadProject) {
                    this.c.loadProject();
                } else if (source == Lateral.this.mnuFileToolImportData) {
                    this.c.newToolImportData();
                } else if (source == Lateral.this.mnuFileExit) {
                    this.c.prepareShutdown();
                    this.parent.dispose();
                    System.exit(0);
                } else if (source != Lateral.this.mnuToolsLangage) {
                    if (source == Lateral.this.mnuPersMDSMetrique) {
                        this.parent.setMDSMetriqueTPG();
                    } else if (source != Lateral.this.mnuToolsMDS) {
                        if (source == Lateral.this.mnuPersACP) {
                            this.parent.setACPTPG();
                        } else if (source == Lateral.this.mnuPersClassif) {
                            this.parent.setClassifTPG();
                        } else if (source == Lateral.this.mnuPersView) {
                            this.parent.setVisuTPG();
                        } else if (source == Lateral.this.mnuPersSVM) {
                            this.parent.setSVMTPG();
                        } else if (source == Lateral.this.mnuToolsIte && this.c.getNbObjects() > 0) {
                            this.parent.setIteTPG();
                        } else if (source == Lateral.this.mnuToolsCrop && this.c.getNbObjects() > 0) {
                            this.parent.setCropTPG();
                        } else if (source == Lateral.this.mnuToolsSampling) {
                            new ICVSampling().getDialog(this.parent).setVisible(true);
                        }
                    }
                }
            }
            if (source == Lateral.this.mnuToolsDimensionsTravel && this.c.getNbObjects() > 0) {
                this.parent.setDimensionsTravelTPG();
            } else if (source != Lateral.this.mnuToolsClass) {
                if (source == Lateral.this.mnuHelpContent) {
                    new HelpContentDialog(this.parent).setVisible(true);
                } else if (source == Lateral.this.mnuHelpContribs) {
                    new ContribDialog(this.parent).setVisible(true);
                } else if (source == Lateral.this.mnuToolsCamera) {
                    if (Lateral.this.mnuToolsCamera.isSelected()) {
                        this.c.f3d.startCamera();
                        System.out.println("demarrer cam");
                    } else {
                        this.c.f3d.stopCamera();
                        System.out.println("stopper cam");
                    }
                } else if (source == Lateral.this.mnuToolsWiimote) {
                    Lateral.this.mnuToolsWiimote.isSelected();
                } else if (source == Lateral.this.mnuToolsDistorsions) {
                    this.c.getTDistorsions().afficherDistorsionsNN();
                } else if (source == Lateral.this.mnuToolsFromImages) {
                    this.c.showFromImages(Lateral.this.mnuToolsFromImages.isSelected());
                } else if (source == Lateral.this.mnuPersMosaic) {
                    ViewManager.getSingleton().mosaic();
                } else {
                    int i = 0;
                    while (i < Lateral.this.fileHistory.length) {
                        if (source == Lateral.this.fileHistory[i]) {
                            Object[] options = new Object[]{Messages.getString("new_project_button"), Messages.getString("additional_data_button")};
                            if (!Lateral.this.multiSrcMode || !Lateral.this.srcLoaded || JOptionPane.showOptionDialog(this.parent, Messages.getString("new_or_not_project_text"), Messages.getString("load_title"), 0, 3, null, options, options[0]) == 0) {
                                Common.getSingleton().reinitialiserParametres();
                                DataManager.getSingleton().reset();
                            }
                            this.c.load(((Lateral)Lateral.this).general.fileHistory.getMethode(i), ((Lateral)Lateral.this).general.fileHistory.getNomFichier(i));
                            return;
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

