/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import lib3d4j.international.Messages;

public class OnlineFileChooser
extends JPanel {
    public static int APPROVE_OPTION = 1;
    public static int CANCEL_OPTION = 2;
    public static int INITIAL_DEPTH = 1;
    public static int INCREMENTAL_DEPTH = 1;
    private JTextField jtfUrl = null;
    private JTextField jtfLogin = null;
    private JPasswordField jpfPassword = null;
    private JButton jbConnect = null;
    private OFCActionListener ofcl = null;
    private JTree jt = null;
    private JButton jbOK = null;
    private JButton jbCancel = null;
    private JScrollPane jsp = null;
    private Component parent = null;
    JDialog jd = null;
    private DefaultTreeModel tm;
    private int state;
    private String selected = null;
    private String protocol = null;

    public OnlineFileChooser() {
        this.setLayout(new BorderLayout());
        this.ofcl = new OFCActionListener();
        this.createConnectPanel();
        this.createBrowsePanel();
        this.createValidatePanel();
    }

    public int showOpen(Component parent) {
        Window pw = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        this.jd = new JDialog(pw, "Choix par url");
        this.jd.getContentPane().add(this);
        this.jd.pack();
        this.jd.setModal(true);
        this.jd.setVisible(true);
        return this.state;
    }

    public int showOpen(String base, Component parent) {
        Window pw = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        this.jd = new JDialog(pw, "Choix par url");
        this.jtfUrl.setText(base);
        this.loadTree(base);
        this.jd.getContentPane().add(this);
        this.jd.pack();
        this.jd.setModal(true);
        this.jd.setVisible(true);
        return this.state;
    }

    public int showOpen(String base, String login, String passwd, Component parent) {
        this.jtfLogin.setText(login);
        this.jpfPassword.setText(passwd);
        this.setAuth(login, passwd.toCharArray());
        return this.showOpen(base, parent);
    }

    public String getSelected() {
        return this.selected;
    }

    @Override
    public void setVisible(boolean b) {
    }

    private void createConnectPanel() {
        JPanel connectPanel = new JPanel(new FlowLayout(3));
        JLabel jl = new JLabel(Messages.getString("online_url"));
        connectPanel.add(jl);
        this.jtfUrl = new JTextField(30);
        connectPanel.add(this.jtfUrl);
        jl = new JLabel(Messages.getString("online_login"));
        connectPanel.add(jl);
        this.jtfLogin = new JTextField(10);
        connectPanel.add(this.jtfLogin);
        jl = new JLabel(Messages.getString("online_passwd"));
        connectPanel.add(jl);
        this.jpfPassword = new JPasswordField(10);
        connectPanel.add(this.jpfPassword);
        this.jbConnect = new JButton(Messages.getString("online_connect"));
        this.jbConnect.addActionListener(this.ofcl);
        connectPanel.add(this.jbConnect);
        this.add((Component)connectPanel, "North");
    }

    private void createBrowsePanel() {
        JPanel browsePanel = new JPanel(new FlowLayout(3));
        this.jt = new JTree(this.fillJT(new OFCNode("", "", "")));
        this.jt.setRootVisible(false);
        this.jsp = new JScrollPane(this.jt, 22, 30);
        this.jsp.setPreferredSize(new Dimension(200, 400));
        browsePanel.add(this.jsp);
        this.add((Component)browsePanel, "Center");
    }

    private void createValidatePanel() {
        JPanel validatePanel = new JPanel(new FlowLayout(3));
        this.jbOK = new JButton(Messages.getString("ok"));
        this.jbOK.addActionListener(this.ofcl);
        validatePanel.add(this.jbOK);
        this.jbCancel = new JButton(Messages.getString("cancel"));
        this.jbCancel.addActionListener(this.ofcl);
        validatePanel.add(this.jbCancel);
        this.add((Component)validatePanel, "South");
    }

    private void defaultConnect() {
    }

    private void loadTree(String url) {
        OFCNode root = null;
        try {
            this.browse(url, "", INITIAL_DEPTH);
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(this, Messages.getString("online_error_text_fnf"), Messages.getString("online_error_title"), 0);
            return;
        }
        try {
            DefaultMutableTreeNode rn = this.fillJT(root);
            this.tm = new DefaultTreeModel(rn);
            this.jt = new JTree(this.tm);
            this.jt.addTreeWillExpandListener(new OFCTreeWillExpandListener());
            this.jsp.setViewportView(this.jt);
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(this, Messages.getString("online_error_text_nodir"), Messages.getString("online_error_title"), 0);
        }
    }

    private void setAuth(String l, char[] p) {
        Authenticator.setDefault(new OFCAuthenticator(l, p));
    }

    private DefaultMutableTreeNode fillJT(OFCNode n) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(n.getNodeContent());
        if (n.getNodeContent().getState() == 3 || n.getNodeContent().getState() == 2) {
            node.add(new DefaultMutableTreeNode());
        } else if (n.hasChildren()) {
            Iterator<OFCNode> it = n.getChildren();
            while (it.hasNext()) {
                node.add(this.fillJT(it.next()));
            }
        }
        return node;
    }

    private ArrayList<DefaultMutableTreeNode> fillChildren(OFCNode n) {
        ArrayList<DefaultMutableTreeNode> res = new ArrayList<DefaultMutableTreeNode>();
        Iterator<OFCNode> children = n.getChildren();
        while (children.hasNext()) {
            res.add(this.fillJT(children.next()));
        }
        return res;
    }

    private OFCNode browse(String base, String suffix, int depth) throws FileNotFoundException {
        try {
            URL url = new URL(base);
            this.protocol = url.getProtocol();
            System.out.println(url.getPath());
            if (this.protocol.equals("file")) {
                return this.recursFile(url.getPath(), suffix, depth);
            }
            if (this.protocol.equals("http")) {
                return this.recursHttp(base, suffix, depth);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return new OFCNode("Error on URL", "", "");
    }

    private OFCNode browse(OFCNode n, int depth) {
        n.getNodeContent().setState(1);
        if (this.protocol.equals("file")) {
            return this.recursFile(n, depth);
        }
        if (this.protocol.equals("http")) {
            return this.recursHttp(n, depth);
        }
        return new OFCNode("Error on URL", "", "");
    }

    private OFCNode recursFile(String base, String suffix, int depth) {
        OFCNode m = new OFCNode(base, suffix, File.separator);
        File f = new File(base, suffix);
        if (f.isDirectory()) {
            Object[] children = f.list();
            if (depth == 0) {
                if (children == null || children.length == 0) {
                    m.getNodeContent().setState(2);
                } else {
                    m.getNodeContent().setState(3);
                }
            } else {
                Arrays.sort(children);
                if (suffix.length() > 0) {
                    suffix = String.valueOf(File.separator) + suffix;
                }
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object s = objectArray[n2];
                    m.addchild(this.recursFile(String.valueOf(base) + suffix, (String)s, depth - 1));
                    ++n2;
                }
            }
        }
        return m;
    }

    private OFCNode recursFile(OFCNode n, int depth) {
        String suffix;
        String url = n.getNodeContent().getUrl();
        String base = url.substring(0, url.length() - n.getNodeContent().toString().length() - 1);
        File f = new File(base, suffix = n.getNodeContent().toString());
        if (f.isDirectory()) {
            Object[] children = f.list();
            if (depth == 0) {
                if (children == null || children.length == 0) {
                    n.getNodeContent().setState(2);
                } else {
                    n.getNodeContent().setState(3);
                }
            } else {
                Arrays.sort(children);
                Object[] objectArray = children;
                int n2 = children.length;
                int n3 = 0;
                while (n3 < n2) {
                    Object s = objectArray[n3];
                    System.out.print(".");
                    n.addchild(this.recursFile(String.valueOf(base) + File.separator + suffix, (String)s, depth - 1));
                    ++n3;
                }
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private OFCNode recursHttp(String base, String suffix, int depth) throws FileNotFoundException {
        block8: {
            m = new OFCNode(base, suffix, "/");
            if (suffix.endsWith(".html") || suffix.endsWith(".png") || suffix.endsWith(".jpg") || suffix.endsWith(".csv") || suffix.endsWith(".ctt")) break block8;
            System.out.println("browse " + base + "--" + suffix);
            if (base.endsWith("/")) {
                base = base.substring(0, base.length() - 1);
            }
            try {
                block9: {
                    url = new URL(String.valueOf(base) + "/" + suffix);
                    System.out.println(url.openConnection().getContentType().startsWith("text/html"));
                    if (!url.openConnection().getContentType().startsWith("text/html")) break block9;
                    rdr = new BufferedReader(new InputStreamReader(url.openStream()));
                    while ((line = rdr.readLine()) != null && line.indexOf("Parent Directory") == -1) {
                    }
                    if (depth != 0) ** GOTO lbl24
                    dest = this.getDest(line);
                    if (dest == null) {
                        m.getNodeContent().setState(2);
                    } else {
                        m.getNodeContent().setState(3);
                    }
                    break block8;
lbl-1000:
                    // 1 sources

                    {
                        dest = this.getDest(line);
                        if (dest == null) continue;
                        System.out.print(".");
                        m.addchild(this.recursHttp(String.valueOf(base) + "/" + suffix, dest, depth - 1));
lbl24:
                        // 3 sources

                        ** while ((line = rdr.readLine()) != null)
                    }
lbl25:
                    // 1 sources

                    System.out.println("");
                    break block8;
                }
                System.out.println("no html file");
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return m;
    }

    private String getDest(String line) {
        String dest = null;
        int start = 0;
        if ((start = line.indexOf("href", start)) != -1) {
            int slash;
            int stop;
            dest = line.substring(start = line.indexOf("\"", start) + 1, stop = line.indexOf("\"", start));
            if (dest.endsWith("/")) {
                dest = dest.substring(0, dest.length() - 1);
            }
            if ((slash = dest.lastIndexOf(47)) != -1) {
                dest = dest.substring(slash + 1);
            }
        }
        return dest;
    }

    private OFCNode recursHttp(OFCNode n, int depth) {
        String surl = n.getNodeContent().getUrl();
        String base = surl.substring(0, surl.length() - n.getNodeContent().toString().length() - 1);
        String suffix = n.getNodeContent().toString();
        if (!suffix.contains(".") || suffix.endsWith("/")) {
            System.out.println("browse " + base + "--" + suffix);
            try {
                String line;
                URL url = new URL(String.valueOf(base) + suffix);
                BufferedReader rdr = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((line = rdr.readLine()) != null && line.indexOf("Parent Directory") == -1) {
                    System.out.println(line);
                }
                while ((line = rdr.readLine()) != null) {
                    System.out.println(line);
                    System.out.print(".");
                    int start = 0;
                    start = line.indexOf("href", start);
                    if (start == -1) continue;
                    start = line.indexOf("\"", start) + 1;
                    int stop = line.indexOf("\"", start);
                    n.addchild(this.recursHttp(String.valueOf(base) + suffix, line.substring(start, stop), depth - 1));
                }
                System.out.println("");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return n;
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.setVisible(true);
        OnlineFileChooser ofc = new OnlineFileChooser();
        System.out.println(ofc.getSelected());
        jf.setVisible(false);
        System.exit(0);
    }

    private class NodeContent {
        static final int EXPANDED = 1;
        static final int EMPTY = 2;
        static final int TOEXPAND = 3;
        private String url;
        private int state = 1;
        private String value;
        private OFCNode node;

        public NodeContent(String url, String value, OFCNode n) {
            this.url = url;
            this.value = value;
            this.node = n;
        }

        public String getUrl() {
            return this.url;
        }

        public String toString() {
            if (this.state == 2) {
                return String.valueOf(this.value) + " (vide)";
            }
            return this.value;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public OFCNode getNode() {
            return this.node;
        }
    }

    private class OFCActionListener
    implements ActionListener {
        private OFCActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == OnlineFileChooser.this.jbConnect) {
                OnlineFileChooser.this.setAuth(OnlineFileChooser.this.jtfLogin.getText(), OnlineFileChooser.this.jpfPassword.getPassword());
                OnlineFileChooser.this.loadTree(OnlineFileChooser.this.jtfUrl.getText());
            } else if (src == OnlineFileChooser.this.jbOK) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)OnlineFileChooser.this.jt.getLastSelectedPathComponent();
                OnlineFileChooser.this.selected = ((NodeContent)node.getUserObject()).getUrl();
                OnlineFileChooser.this.state = APPROVE_OPTION;
                OnlineFileChooser.this.jd.setVisible(false);
            } else if (src == OnlineFileChooser.this.jbCancel) {
                OnlineFileChooser.this.state = CANCEL_OPTION;
                OnlineFileChooser.this.jd.setVisible(false);
            }
        }
    }

    private class OFCAuthenticator
    extends Authenticator {
        private String l;
        private char[] p;

        protected OFCAuthenticator(String l, char[] p) {
            this.l = l;
            this.p = p;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String promptString = this.getRequestingPrompt();
            String hostname = this.getRequestingHost();
            InetAddress ipaddr = this.getRequestingSite();
            int port = this.getRequestingPort();
            return new PasswordAuthentication(this.l, this.p);
        }
    }

    private class OFCNode {
        NodeContent nc;
        ArrayList<OFCNode> children;

        public OFCNode(String path, String v, String sep) {
            this.nc = new NodeContent(String.valueOf(path) + sep + v, v, this);
            this.children = new ArrayList();
        }

        public void addchild(OFCNode m) {
            this.children.add(m);
        }

        public Iterator<OFCNode> getChildren() {
            return this.children.iterator();
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public NodeContent getNodeContent() {
            return this.nc;
        }
    }

    private class OFCTreeModel
    extends DefaultTreeModel {
        public OFCTreeModel(TreeNode root) {
            super(root);
        }
    }

    private class OFCTreeWillExpandListener
    implements TreeWillExpandListener {
        private OFCTreeWillExpandListener() {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent arg0) throws ExpandVetoException {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
            DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
            NodeContent nc = (NodeContent)dmt.getUserObject();
            if (nc.getState() == 2) {
                throw new ExpandVetoException(e);
            }
            if (nc.getState() == 3) {
                System.out.println("To expand");
                String url = nc.getUrl();
                String base = url.substring(0, url.length() - nc.toString().length() - 1);
                OFCNode n = nc.getNode();
                OnlineFileChooser.this.browse(n, INCREMENTAL_DEPTH);
                dmt.removeAllChildren();
                ArrayList desc = OnlineFileChooser.this.fillChildren(n);
                int index = 0;
                for (DefaultMutableTreeNode child : desc) {
                    OnlineFileChooser.this.tm.insertNodeInto(child, dmt, index);
                    ++index;
                }
            }
        }
    }
}

