/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import explorer.data.Common;
import explorer.data.OptionsExplorer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib3d4j.international.Messages;

public class OptionsDialog
extends JDialog {
    private Common parent;
    private JCheckBox jcbInitialRotation;
    private JCheckBox afficherAxesOriginaux;
    protected LegendSquare lsDefaultColor;
    protected JButton jbOk;
    protected JCheckBox jcbRemoteView;
    protected JCheckBox jcbStandAlonePictures;
    protected JTextField jtfHistorySize;
    protected JCheckBox jcbLoadAndShow;
    protected JCheckBox jcbCropInNewWindow;
    protected JCheckBox jcbAttributesDialog;
    protected JCheckBox jcbPictureMouse;
    protected JCheckBox jcbStereo;
    protected JCheckBox jcbDynObjSize;
    private JSlider jsLabelSize;
    private JSlider jsObjectSize;
    private JCheckBox jcbMultiSource;
    private OptionsExplorer opt = OptionsExplorer.getSingleton();
    private JCheckBox jcbListenToPort;
    private JTextField jtfPortNumber;
    private JCheckBox jcbLegendDisplayed;

    public OptionsDialog(Common com) {
        super(null, Messages.getString("options_title"), Dialog.ModalityType.APPLICATION_MODAL);
        int nbLayouts = 12;
        JPanel descriptions = new JPanel();
        descriptions.setLayout(new GridLayout(0, 1));
        JPanel choix = new JPanel();
        choix.setLayout(new GridLayout(0, 1));
        this.parent = com;
        OptionActionListener al = new OptionActionListener();
        this.setLocation(100, 0);
        Container c = this.getContentPane();
        this.add((Component)descriptions, "West");
        this.add((Component)choix, "East");
        LDMouseAdapter ldma = new LDMouseAdapter(this);
        OptionChangeListener ocl = new OptionChangeListener();
        JLabel jl = new JLabel(String.valueOf(Messages.getString("default_color")) + " :  ");
        this.lsDefaultColor = new LegendSquare(this.opt.getDefaultColor());
        this.lsDefaultColor.addMouseListener(ldma);
        jl = new JLabel(String.valueOf(Messages.getString("option_rotate_beggining")) + " :  ");
        descriptions.add(jl);
        this.jcbInitialRotation = new JCheckBox();
        this.jcbInitialRotation.setSelected(this.opt.isInitialRotation());
        this.jcbInitialRotation.addActionListener(al);
        choix.add(this.jcbInitialRotation);
        jl = new JLabel(String.valueOf(Messages.getString("print_axis")) + " :  ");
        descriptions.add(jl);
        this.afficherAxesOriginaux = new JCheckBox();
        this.afficherAxesOriginaux.addActionListener(al);
        choix.add(this.afficherAxesOriginaux);
        jl = new JLabel(String.valueOf(Messages.getString("tpgimage_window_mode")) + " :  ");
        descriptions.add(jl);
        this.jcbStandAlonePictures = new JCheckBox();
        this.jcbStandAlonePictures.setSelected(this.opt.isStandAloneFigures());
        this.jcbStandAlonePictures.addActionListener(al);
        choix.add(this.jcbStandAlonePictures);
        jl = new JLabel(String.valueOf(Messages.getString("option_load_and_show")) + " :  ");
        descriptions.add(jl);
        this.jcbLoadAndShow = new JCheckBox();
        this.jcbLoadAndShow.setSelected(this.opt.isLoadAndShow());
        this.jcbLoadAndShow.addActionListener(al);
        choix.add(this.jcbLoadAndShow);
        jl = new JLabel(String.valueOf(Messages.getString("option_crop_in_new_window")) + " :  ");
        descriptions.add(jl);
        this.jcbCropInNewWindow = new JCheckBox();
        this.jcbCropInNewWindow.setSelected(this.opt.isCropInNewWindow());
        this.jcbCropInNewWindow.addActionListener(al);
        choix.add(this.jcbCropInNewWindow);
        jl = new JLabel(String.valueOf(Messages.getString("activate_RMI")) + " :  ");
        descriptions.add(jl);
        this.jcbRemoteView = new JCheckBox();
        this.jcbRemoteView.setSelected(this.opt.isRemoteView());
        this.jcbRemoteView.addActionListener(al);
        choix.add(this.jcbRemoteView);
        jl = new JLabel(String.valueOf(Messages.getString("option_show_attributes")) + " :  ");
        descriptions.add(jl);
        this.jcbAttributesDialog = new JCheckBox();
        this.jcbAttributesDialog.setSelected(this.opt.isShowAttributesDialog());
        this.jcbAttributesDialog.addActionListener(al);
        choix.add(this.jcbAttributesDialog);
        jl = new JLabel(String.valueOf(Messages.getString("option_picture_mouse_over")) + " :  ");
        descriptions.add(jl);
        this.jcbPictureMouse = new JCheckBox();
        this.jcbPictureMouse.setSelected(this.opt.isShowFigureOnMouseOver());
        this.jcbPictureMouse.addActionListener(al);
        choix.add(this.jcbPictureMouse);
        jl = new JLabel(String.valueOf(Messages.getString("option_stereo")) + " :  ");
        descriptions.add(jl);
        this.jcbStereo = new JCheckBox();
        this.jcbStereo.setSelected(this.opt.isStereo());
        this.jcbStereo.addActionListener(al);
        choix.add(this.jcbStereo);
        jl = new JLabel(String.valueOf(Messages.getString("option_labels_size")) + " :  ");
        descriptions.add(jl);
        this.jsLabelSize = new JSlider(1, 5, 4);
        this.jsLabelSize.setInverted(false);
        this.jsLabelSize.setMajorTickSpacing(1);
        this.jsLabelSize.setMinorTickSpacing(1);
        this.jsLabelSize.setPaintTicks(true);
        this.jsLabelSize.addChangeListener(ocl);
        choix.add(this.jsLabelSize);
        jl = new JLabel(String.valueOf(Messages.getString("option_dynamic_objects_size")) + " :  ");
        descriptions.add(jl);
        this.jcbDynObjSize = new JCheckBox();
        this.jcbDynObjSize.setSelected(this.opt.isDynamicObjectSize());
        this.jcbDynObjSize.addActionListener(al);
        choix.add(this.jcbDynObjSize);
        jl = new JLabel(String.valueOf(Messages.getString("option_objects_size")) + " :  ");
        descriptions.add(jl);
        this.jsObjectSize = new JSlider(1, 100, (int)(10.0f * this.opt.getObjectSize()));
        this.jsObjectSize.setInverted(false);
        this.jsObjectSize.setMajorTickSpacing(1);
        this.jsObjectSize.setMinorTickSpacing(1);
        this.jsObjectSize.setPaintTicks(true);
        this.jsObjectSize.addChangeListener(ocl);
        this.jsObjectSize.setEnabled(!this.opt.isDynamicObjectSize());
        choix.add(this.jsObjectSize);
        if (Common.MULTI) {
            jl = new JLabel(Messages.getString("option_multisource"));
            descriptions.add(jl);
            this.jcbMultiSource = new JCheckBox();
            this.jcbMultiSource.setSelected(this.opt.isMultiSource());
            this.jcbMultiSource.addActionListener(al);
            choix.add(this.jcbMultiSource);
        } else {
            this.opt.setMultiSource(false);
        }
        jl = new JLabel(String.valueOf(Messages.getString("option_listen_to_port")) + " :  ");
        descriptions.add(jl);
        this.jcbListenToPort = new JCheckBox();
        this.jcbListenToPort.setSelected(this.opt.isListenToPort());
        this.jcbListenToPort.addActionListener(al);
        choix.add(this.jcbListenToPort);
        jl = new JLabel(String.valueOf(Messages.getString("option_port_number")) + " :  ");
        descriptions.add(jl);
        this.jtfPortNumber = new JTextField();
        this.jtfPortNumber.setText("" + this.opt.getPortNumber());
        this.jtfPortNumber.addActionListener(al);
        this.jtfPortNumber.setEnabled(false);
        choix.add(this.jtfPortNumber);
        jl = new JLabel(String.valueOf(Messages.getString("option_display_legend")) + " :  ");
        descriptions.add(jl);
        this.jcbLegendDisplayed = new JCheckBox();
        this.jcbLegendDisplayed.setSelected(this.opt.isLegendDisplayed());
        this.jcbLegendDisplayed.addActionListener(al);
        choix.add(this.jcbLegendDisplayed);
        this.jbOk = new JButton("OK");
        this.jbOk.addActionListener(al);
        this.add((Component)this.jbOk, "South");
        this.pack();
    }

    public boolean isAfficheCoche() {
        return this.jcbStandAlonePictures.isSelected();
    }

    public void reinitialiser() {
        this.afficherAxesOriginaux.setSelected(false);
    }

    public void isValorisation(boolean nomParametre) {
        if (nomParametre && !this.jcbInitialRotation.isSelected() || !nomParametre && this.jcbInitialRotation.isSelected()) {
            this.jcbInitialRotation.doClick();
        }
    }

    public void isAfficherAxes(boolean nomParametre) {
        if (nomParametre && !this.afficherAxesOriginaux.isSelected() || !nomParametre && this.afficherAxesOriginaux.isSelected()) {
            this.afficherAxesOriginaux.doClick();
        }
    }

    public void isImageHors3D(boolean nomParametre) {
        if (nomParametre && !this.jcbStandAlonePictures.isSelected() || !nomParametre && this.jcbStandAlonePictures.isSelected()) {
            this.jcbStandAlonePictures.doClick();
        }
    }

    public void isCalculeVue3DChargement(boolean nomParametre) {
        if (nomParametre && !this.jcbLoadAndShow.isSelected() || !nomParametre && this.jcbLoadAndShow.isSelected()) {
            this.jcbLoadAndShow.doClick();
        }
    }

    public void isZoomNouvelleFen\u00eatre(boolean nomParametre) {
        if (nomParametre && !this.jcbCropInNewWindow.isSelected() || !nomParametre && this.jcbCropInNewWindow.isSelected()) {
            this.jcbCropInNewWindow.doClick();
        }
    }

    public void isActivationEnvoiDistant(boolean nomParametre) {
        if (nomParametre && !this.jcbRemoteView.isSelected() || !nomParametre && this.jcbRemoteView.isSelected()) {
            this.jcbRemoteView.doClick();
        }
    }

    public void isAffichageTableau(boolean nomParametre) {
        if (nomParametre && !this.jcbAttributesDialog.isSelected() || !nomParametre && this.jcbAttributesDialog.isSelected()) {
            this.jcbAttributesDialog.doClick();
        }
    }

    public void setTailleLabels(int nomParametre) {
        this.jsLabelSize.setValue(nomParametre);
    }

    public void close() {
        this.jbOk.doClick();
    }

    final class LDMouseAdapter
    extends MouseAdapter {
        private OptionsDialog parent = null;

        public LDMouseAdapter(OptionsDialog ld) {
            this.parent = ld;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object src = e.getSource();
            LegendSquare square = (LegendSquare)src;
            Color newCol = JColorChooser.showDialog(this.parent, Messages.getString("color_modify"), square.getColor());
            if (newCol != null) {
                square.setColor(newCol);
                OptionsDialog.this.opt.setDefaultColor(newCol);
                this.parent.parent.setOptions();
            }
        }
    }

    final class LegendSquare
    extends JLabel {
        private Color color = null;
        public static final long serialVersionUID = 1L;

        public LegendSquare(Color col) {
            this.color = col;
            this.setBackground(this.color);
            this.setPreferredSize(new Dimension(30, 15));
            this.setMaximumSize(new Dimension(30, 15));
            this.setOpaque(true);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        public void setColor(Color col) {
            this.color = col;
            this.setBackground(this.color);
        }

        public Color getColor() {
            return this.color;
        }
    }

    final class OptionActionListener
    implements ActionListener {
        OptionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == OptionsDialog.this.jcbInitialRotation) {
                OptionsDialog.this.opt.setInitialRotation(OptionsDialog.this.jcbInitialRotation.isSelected());
            } else if (src == OptionsDialog.this.afficherAxesOriginaux) {
                if (OptionsDialog.this.afficherAxesOriginaux.isSelected()) {
                    OptionsDialog.this.parent.getTAxesOriginaux().afficherProjectionDimensionsOriginelles();
                } else {
                    OptionsDialog.this.parent.getTAxesOriginaux().effacerProjectionDimensionsOriginelles();
                }
            } else if (src == OptionsDialog.this.jcbRemoteView) {
                OptionsDialog.this.opt.setRemoteView(OptionsDialog.this.jcbRemoteView.isSelected());
            } else if (src == OptionsDialog.this.jcbStandAlonePictures) {
                OptionsDialog.this.opt.setStandAloneFigures(OptionsDialog.this.jcbStandAlonePictures.isSelected());
            } else if (src == OptionsDialog.this.jcbLoadAndShow) {
                OptionsDialog.this.opt.setLoadAndShow(OptionsDialog.this.jcbLoadAndShow.isSelected());
            } else if (src == OptionsDialog.this.jtfHistorySize) {
                OptionsDialog.this.opt.setHistorySize(Integer.parseInt(OptionsDialog.this.jtfHistorySize.getText()));
            } else if (src == OptionsDialog.this.jcbCropInNewWindow) {
                OptionsDialog.this.opt.setCropInNewWindow(OptionsDialog.this.jcbCropInNewWindow.isSelected());
            } else if (src == OptionsDialog.this.jcbAttributesDialog) {
                OptionsDialog.this.opt.setShowAttributesDialog(OptionsDialog.this.jcbAttributesDialog.isSelected());
            } else if (src == OptionsDialog.this.jcbPictureMouse) {
                OptionsDialog.this.opt.setShowFigureOnMouseOver(OptionsDialog.this.jcbPictureMouse.isSelected());
            } else if (src == OptionsDialog.this.jcbStereo) {
                OptionsDialog.this.opt.setStereo(OptionsDialog.this.jcbStereo.isSelected());
            } else if (src == OptionsDialog.this.jcbDynObjSize) {
                OptionsDialog.this.opt.setDynamicObjectSize(OptionsDialog.this.jcbDynObjSize.isSelected());
                OptionsDialog.this.jsObjectSize.setEnabled(!OptionsDialog.this.opt.isDynamicObjectSize());
            } else if (src == OptionsDialog.this.jcbMultiSource) {
                OptionsDialog.this.opt.setMultiSource(OptionsDialog.this.jcbMultiSource.isSelected());
            } else if (src == OptionsDialog.this.jcbListenToPort) {
                OptionsDialog.this.opt.setListenToPort(OptionsDialog.this.jcbListenToPort.isSelected());
            } else if (src != OptionsDialog.this.jtfPortNumber && src == OptionsDialog.this.jcbLegendDisplayed) {
                OptionsDialog.this.opt.setLegendDisplayed(OptionsDialog.this.jcbLegendDisplayed.isSelected());
            }
            if (src == OptionsDialog.this.jbOk) {
                OptionsDialog.this.dispose();
            } else {
                OptionsDialog.this.parent.setOptions();
            }
        }
    }

    final class OptionChangeListener
    implements ChangeListener {
        OptionChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            try {
                JSlider jsl = (JSlider)ev.getSource();
                if (jsl == OptionsDialog.this.jsLabelSize) {
                    float taille = OptionsDialog.this.jsLabelSize.getValue();
                    ((OptionsDialog)OptionsDialog.this).parent.f3d.setLabelSize(taille / 4.0f);
                    OptionsDialog.this.opt.setLabelSize((int)taille);
                } else if (jsl == OptionsDialog.this.jsObjectSize) {
                    float taille = (float)jsl.getValue() / 10.0f;
                    OptionsDialog.this.parent.setObjectScale(taille);
                    OptionsDialog.this.opt.setObjectSize(taille);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            OptionsDialog.this.parent.setOptions();
        }
    }
}

