/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import explorer.compute.tools.PCTool;
import explorer.data.Common;
import explorer.data.DataManager;
import explorer.data.ViewManager;
import explorer.data.ViewObserver;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.utils.GView;
import explorer.windows.w2D.utils.ImageAndNeighborsPanel;
import explorer.windows.w2D.utils.ImgComparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import lib3d4j.compute.tools.OutilsAlgebre;
import lib3d4j.data.DescriptionData;
import lib3d4j.display3D.Display;
import lib3d4j.international.Messages;
import lib3d4j.w2d.ImageDisplayerException;

public class SubsetExplorer
extends JFrame
implements ViewObserver {
    private static final long serialVersionUID = 1L;
    private Display display;
    private URL dir;
    private PCTool c;
    SEMouseListener ml = null;
    private JPanel centerPanel = null;
    private ArrayList<TreeMap<Integer, Integer>> nbgOfWho = null;
    private ArrayList<ArrayList<Integer>> nbg = null;
    private ArrayList<ImageAndNeighborsPanel> imgAndNbg = null;
    private TreeMap<Integer, Integer> imgIndices = null;
    private JTabbedPane northPanel;
    private String[] imgNames;
    private TreeMap<String, Integer> imgMap;
    private JButton jbSearchImgCB;
    private JComboBox jcbSearchImg;
    private JTextField jtfSearchImg;
    private JButton jbSearchImgTF;
    private JLabel jlK;
    private JTextField jtfK;
    private JButton jbK;
    private JLabel jlZoom;
    private JCheckBox jcbZoom;
    private JPanel southPanel;
    private JButton jbCompute;
    private JButton jbReset;
    private JButton jbClose;
    private ImgComparator comparator = null;
    private DescriptionData dd = DataManager.getSingleton().getCompAttr();
    private int nbobj;
    private int k = 0;

    public SubsetExplorer(int x, int y, Display d, PCTool c) {
        this.setLocation(new Point(x, y));
        this.setTitle(Messages.getString("subset_title"));
        this.display = d;
        this.c = c;
        this.dir = DataManager.getSingleton().getParams().getImagePath();
        System.out.println(this.dir);
        this.nbobj = this.dd.getNbDescrObjects();
        this.initStructures();
        this.ml = new SEMouseListener(this);
        this.addNorthPanel();
        this.addCenterPanel();
        this.addSouthPanel();
        this.pack();
        this.setDefaultCloseOperation(0);
        c.setSubsetEx(this);
        ViewManager.getSingleton().addViewObserver(this);
        GView gv = ViewManager.getSingleton().getActiveView();
        if (gv != null && gv instanceof DisplayExplorer) {
            this.display = (DisplayExplorer)gv;
        }
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        this.display.setAllObjectsVisible(!b);
        if (b) {
            for (int rank : this.imgIndices.values()) {
                this.display.setObjectVisible(rank, true);
            }
        } else if (this.comparator != null) {
            this.comparator.setVisible(false);
            this.comparator.dispose();
            this.comparator = null;
        }
        super.setVisible(b);
    }

    private void initStructures() {
        this.nbg = new ArrayList();
        this.nbgOfWho = new ArrayList(this.nbobj);
        int i = 0;
        while (i < this.nbobj) {
            this.nbgOfWho.add(new TreeMap());
            ++i;
        }
        this.imgAndNbg = new ArrayList();
        this.imgIndices = new TreeMap();
    }

    private void addNorthPanel() {
        this.imgNames = new String[this.nbobj];
        this.imgMap = new TreeMap();
        int i = 0;
        while (i < this.nbobj) {
            this.imgNames[i] = (String)this.dd.getAssocDataValue(i);
            this.imgMap.put(this.imgNames[i], i);
            ++i;
        }
        Arrays.sort(this.imgNames);
        this.northPanel = new JTabbedPane();
        JPanel jpParam = new JPanel(new FlowLayout(0));
        this.jcbSearchImg = new JComboBox<String>(this.imgNames);
        jpParam.add(this.jcbSearchImg);
        this.jbSearchImgCB = new JButton(Messages.getString("validate"));
        this.jbSearchImgCB.addMouseListener(this.ml);
        jpParam.add(this.jbSearchImgCB);
        this.northPanel.add((Component)jpParam, Messages.getString("subset_list"));
        jpParam = new JPanel(new FlowLayout(0));
        this.jtfSearchImg = new JTextField(this.imgNames[0]);
        this.jtfSearchImg.addCaretListener(new SECaretListener());
        jpParam.add(this.jtfSearchImg);
        this.jbSearchImgTF = new JButton(Messages.getString("validate"));
        this.jbSearchImgTF.addMouseListener(this.ml);
        jpParam.add(this.jbSearchImgTF);
        this.northPanel.add((Component)jpParam, Messages.getString("subset_name"));
        jpParam = new JPanel(new FlowLayout(0));
        this.jlK = new JLabel(String.valueOf(Messages.getString("subset_nbnbg")) + ":");
        jpParam.add(this.jlK);
        this.jtfK = new JTextField(3);
        this.jtfK.setText("" + this.k);
        jpParam.add(this.jtfK);
        this.jbK = new JButton(Messages.getString("validate"));
        this.jbK.addMouseListener(this.ml);
        jpParam.add(this.jbK);
        this.northPanel.add((Component)jpParam, Messages.getString("subset_nbg"));
        jpParam = new JPanel(new FlowLayout(0));
        this.jlZoom = new JLabel(String.valueOf(Messages.getString("subset_zoom")) + " :");
        this.jlZoom.setToolTipText(Messages.getString("subset_zoom_tooltip"));
        jpParam.add(this.jlZoom);
        this.jcbZoom = new JCheckBox();
        this.jcbZoom.addMouseListener(this.ml);
        this.jcbZoom.setToolTipText(Messages.getString("subset_zoom_tooltip"));
        jpParam.add(this.jcbZoom);
        this.northPanel.add((Component)jpParam, Messages.getString("subset_zoom"));
        this.add((Component)this.northPanel, "North");
    }

    private void addCenterPanel() {
        this.centerPanel = new JPanel(new GridLayout(0, 1));
        this.add((Component)this.centerPanel, "Center");
    }

    private void addSouthPanel() {
        this.southPanel = new JPanel();
        this.jbCompute = new JButton(Messages.getString("subset_proj"));
        this.jbCompute.setForeground(Color.blue);
        this.jbCompute.setFont(this.jbCompute.getFont().deriveFont(1));
        this.jbCompute.addMouseListener(this.ml);
        this.southPanel.add(this.jbCompute);
        this.jbReset = new JButton(Messages.getString("subset_reset"));
        this.jbReset.setForeground(Color.red);
        this.jbReset.setFont(this.jbReset.getFont().deriveFont(1));
        this.jbReset.addMouseListener(this.ml);
        this.southPanel.add(this.jbReset);
        this.jbClose = new JButton(Messages.getString("close"));
        this.jbClose.addMouseListener(this.ml);
        this.southPanel.add(this.jbClose);
        this.add((Component)this.southPanel, "South");
    }

    private int modifyK(int newk) {
        if (newk > this.nbobj - 1) {
            newk = this.nbobj - 1;
        }
        if (this.k != newk) {
            int i;
            Cursor hourglassCursor = new Cursor(3);
            this.setCursor(hourglassCursor);
            if (this.k > newk) {
                i = 0;
                while (i < this.imgIndices.size()) {
                    ImageAndNeighborsPanel inp = this.imgAndNbg.get(i);
                    inp.removeLastNeighbor(this.k - newk);
                    int j = this.k - 1;
                    while (j >= newk) {
                        int rank = this.nbg.get(i).remove(this.nbg.get(i).size() - 1);
                        this.nbgOfWho.get(rank).remove(i);
                        if (this.nbgOfWho.get(rank).isEmpty() && !this.imgIndices.containsKey(rank)) {
                            this.display.setObjectVisible(rank, false);
                        }
                        --j;
                    }
                    ++i;
                }
            } else if (this.k < newk) {
                i = 0;
                while (i < this.imgIndices.size()) {
                    this.computeNeighbors(i, this.k, newk);
                    ++i;
                }
            }
            this.k = newk;
            this.pack();
            Cursor normalCursor = new Cursor(0);
            this.setCursor(normalCursor);
        }
        return newk;
    }

    private void computeNeighbors(int i, int kmin, int kmax) {
        if (kmax > kmin) {
            int[] neighbors = OutilsAlgebre.kNearestNeighbors(kmax, this.imgIndices.get(i), this.display.getPoints());
            ImageAndNeighborsPanel inp = this.imgAndNbg.get(i);
            int j = kmin;
            while (j < kmax) {
                int rank = neighbors[j];
                try {
                    inp.addNeighbor(String.valueOf(rank) + " (" + (String)this.dd.getAssocDataValue(rank) + ")", this.dir, (String)this.dd.getAssocDataValue(rank), rank);
                    this.display.setObjectVisible(rank, true);
                    this.nbg.get(i).add(rank);
                    this.nbgOfWho.get(rank).put(i, null);
                }
                catch (ImageDisplayerException imageDisplayerException) {
                    // empty catch block
                }
                ++j;
            }
        }
    }

    private void reset() {
        this.c.clean();
        this.initStructures();
        this.centerPanel.removeAll();
        this.pack();
        this.display.setAllObjectsVisible(false);
    }

    private void addObject(int rank) {
        if (!this.imgIndices.containsValue(rank)) {
            Cursor hourglassCursor = new Cursor(3);
            this.setCursor(hourglassCursor);
            ImageAndNeighborsPanel inp = new ImageAndNeighborsPanel(String.valueOf(rank) + " (" + (String)this.dd.getAssocDataValue(rank) + ")", this.dir, (String)this.dd.getAssocDataValue(rank), rank, this.display, this);
            int i = this.imgAndNbg.size();
            this.imgAndNbg.add(inp);
            this.centerPanel.add(inp);
            this.nbg.add(new ArrayList());
            this.imgIndices.put(i, rank);
            this.display.setObjectVisible(rank, true);
            this.computeNeighbors(i, 0, this.k);
            this.pack();
            Cursor normalCursor = new Cursor(0);
            this.setCursor(normalCursor);
        }
    }

    public String[] addConstraint(int numimg, int numnbg, boolean isRight) {
        ArrayList<Integer> nbgOfImg = null;
        int i = 0;
        while (i < this.imgIndices.size()) {
            if (this.imgIndices.get(i) == numimg) {
                nbgOfImg = this.nbg.get(i);
                break;
            }
            ++i;
        }
        return this.c.addSEConstraint(numimg, numnbg, nbgOfImg, isRight);
    }

    @Override
    public void activeViewChanged(GView gv) {
        this.display = gv instanceof DisplayExplorer ? (DisplayExplorer)gv : null;
    }

    protected class SECaretListener
    implements CaretListener {
        protected SECaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent arg0) {
            SubsetExplorer.this.jbSearchImgTF.setEnabled(SubsetExplorer.this.imgMap.containsKey(SubsetExplorer.this.jtfSearchImg.getText()));
        }
    }

    protected class SEMouseListener
    implements MouseListener {
        private JFrame parent;

        public SEMouseListener(JFrame p) {
            this.parent = p;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object src = e.getSource();
            if (src == SubsetExplorer.this.jbSearchImgCB) {
                int indice = (Integer)SubsetExplorer.this.imgMap.get(SubsetExplorer.this.jcbSearchImg.getSelectedItem());
                SubsetExplorer.this.addObject(indice);
                System.out.println(indice);
            } else if (src == SubsetExplorer.this.jbSearchImgTF) {
                int indice = (Integer)SubsetExplorer.this.imgMap.get(SubsetExplorer.this.jtfSearchImg.getText());
                SubsetExplorer.this.addObject(indice);
                System.out.println(indice);
            } else if (src == SubsetExplorer.this.jbK) {
                int newK = Integer.parseInt(SubsetExplorer.this.jtfK.getText());
                SubsetExplorer.this.jtfK.setText("" + SubsetExplorer.this.modifyK(newK));
            } else if (src == SubsetExplorer.this.jbCompute) {
                SubsetExplorer.this.c.compute();
                int currentK = SubsetExplorer.this.k;
                SubsetExplorer.this.modifyK(0);
                SubsetExplorer.this.modifyK(currentK);
            } else if (src == SubsetExplorer.this.jbReset) {
                if (SubsetExplorer.this.imgAndNbg.size() > 0) {
                    Object[] options = new Object[]{Messages.getString("yes"), Messages.getString("no")};
                    int n = JOptionPane.showOptionDialog(this.parent, Messages.getString("subset_resetlist"), Messages.getString("subset_reset"), 0, 3, null, options, options[1]);
                    if (n == 0) {
                        SubsetExplorer.this.reset();
                    }
                }
            } else if (src == SubsetExplorer.this.jbClose) {
                Common.getSingleton().getLateral().mnuToolsFromImages.setSelected(false);
                SubsetExplorer.this.setVisible(false);
            } else if (src == SubsetExplorer.this.jcbZoom) {
                if (SubsetExplorer.this.jcbZoom.isSelected()) {
                    SubsetExplorer.this.comparator = new ImgComparator();
                    SubsetExplorer.this.comparator.setVisible(true);
                } else {
                    SubsetExplorer.this.comparator.setVisible(false);
                    SubsetExplorer.this.comparator.dispose();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

