/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import explorer.data.Common;
import explorer.data.DataManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import lib3d4j.international.Messages;

public class ToolImportData
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Vector<String> lineFileImportDataOld;
    private Vector<String> lineFileImportDataNew;
    private ArrayList<Vector<String>> historique;
    private JPanel jpTools;
    private JList elemFileOld;
    private JList elemFileNew;
    private JTextField jtNbObjects;
    private JTextField jtNbAttributes;
    private int[] numberObjectAttributes;
    private JButton jbseparator;
    JPanel jpMoveC;
    private int nbElem = 0;
    private boolean ajoutObAtt = false;
    private JMenu mnuFile;
    private JMenuItem mnuFileExit;
    private JMenuBar mnu;
    private MenuTIDActionListener mtidal;
    private Common parent;
    private File file;
    private boolean standalone;
    private boolean change = false;
    private int dataType = 1000;
    private boolean namesGiven = false;
    private int nbLines;
    private int nbCols;
    private JScrollPane oldScrollScript;
    private Object[][] rowData;
    private int nbAttrComp;
    private JPanel jpOld;

    public ToolImportData(Common parent, String file, boolean b) {
        this(parent, new File(file), b);
    }

    public ToolImportData(Common parent, File file, boolean b) {
        this.parent = parent;
        this.standalone = b;
        this.file = file;
        this.lineFileImportDataOld = new Vector();
        this.lineFileImportDataNew = new Vector();
        this.historique = new ArrayList();
        this.fenetreImportData();
        this.setModal(true);
    }

    private void fenetreImportData() {
        this.setTitle(Messages.getString("load_tool_import_data"));
        this.setLayout(new BorderLayout());
        this.elemFileOld = new JList<String>(this.lineFileImportDataOld);
        this.elemFileOld.setLayoutOrientation(0);
        this.elemFileOld.setSelectionMode(0);
        this.elemFileNew = new JList<String>(this.lineFileImportDataNew);
        this.elemFileNew.setLayoutOrientation(0);
        this.elemFileNew.setSelectionMode(0);
        this.mtidal = new MenuTIDActionListener();
        this.addMenu();
        this.addCenter();
        this.numberObjectsAttributes();
        if (this.file == null) {
            this.goTo(1);
        } else {
            this.loadFileOld();
            this.goTo(2);
        }
        this.pack();
    }

    private void addCenter() {
        JPanel jpCenter = new JPanel(new GridBagLayout());
        Dimension prefsize = Toolkit.getDefaultToolkit().getScreenSize();
        prefsize.height = (int)((double)prefsize.height / 2.5);
        prefsize.width = (int)((double)prefsize.width / 2.5);
        if (prefsize.height > 200) {
            prefsize.height = 200;
        }
        if (prefsize.width > 400) {
            prefsize.width = 400;
        }
        this.jpOld = new JPanel();
        this.jpOld.setLayout(new BorderLayout());
        this.jpOld.setBorder(BorderFactory.createTitledBorder(Messages.getString("toolimport_old")));
        this.oldScrollScript = new JScrollPane();
        this.oldScrollScript.setMinimumSize(prefsize);
        this.oldScrollScript.setPreferredSize(prefsize);
        this.oldScrollScript.setVisible(true);
        this.jpOld.add((Component)this.oldScrollScript, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 12;
        jpCenter.add((Component)this.jpOld, gbc);
        JPanel jpNew = new JPanel();
        jpNew.setLayout(new BorderLayout());
        jpNew.setBorder(BorderFactory.createTitledBorder(Messages.getString("toolimport_new")));
        JScrollPane newScrollScript = new JScrollPane(this.elemFileNew);
        newScrollScript.setPreferredSize(prefsize);
        newScrollScript.setMinimumSize(prefsize);
        newScrollScript.setVisible(true);
        jpNew.add((Component)newScrollScript, "Center");
        gbc.gridx = 0;
        gbc.gridy = 1;
        jpCenter.add((Component)jpNew, gbc);
        this.jpTools = new JPanel();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        jpCenter.add((Component)this.jpTools, gbc);
        this.add((Component)jpCenter, "Center");
    }

    private void addMenu() {
        this.mnu = new JMenuBar();
        this.mnuFile = new JMenu(Messages.getString("files"));
        this.mnuFileExit = new JMenuItem(Messages.getString("exit"));
        this.mnuFileExit.addActionListener(this.mtidal);
        this.mnuFileExit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.mnuFile.add(this.mnuFileExit);
        this.mnu.add(this.mnuFile);
        this.setJMenuBar(this.mnu);
    }

    protected void goTo(int step) {
        Component c;
        BoxedPanel jpNext = null;
        if (step == 1) {
            jpNext = new StepOne();
        } else if (step == 1) {
            jpNext = new StepOne();
        } else if (step == 2) {
            jpNext = new StepTwo();
        } else if (step == 3) {
            jpNext = new StepThree();
        } else if (step == 4) {
            jpNext = new StepFour();
        } else if (step == 5) {
            jpNext = new StepFive();
        } else if (step == 6) {
            jpNext = new StepSix();
        }
        Component[] componentArray = jpNext.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = componentArray[n2];
            ((JComponent)c).setAlignmentX(0.0f);
            ++n2;
        }
        componentArray = this.jpTools.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            c = componentArray[n2];
            c.setVisible(false);
            ++n2;
        }
        this.jpTools.removeAll();
        this.jpTools.setBorder(BorderFactory.createTitledBorder(jpNext.getTitle()));
        this.jpTools.add(jpNext);
        this.pack();
    }

    private boolean loadSource() {
        URL u = DataManager.getSingleton().getParams().getCurrentPath();
        String path = u.getProtocol().equals("file") ? u.getPath() : System.getProperty("user.dir");
        JFileChooser chooser = new JFileChooser(path);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            this.file = chooser.getSelectedFile();
            this.loadFileOld();
            return true;
        }
        return false;
    }

    private void loadFileOld() {
        try {
            String ligneFichier;
            BufferedReader fR = new BufferedReader(new FileReader(this.file));
            while ((ligneFichier = fR.readLine()) != null) {
                this.lineFileImportDataOld.add(ligneFichier);
            }
            this.elemFileOld.setListData(this.lineFileImportDataOld);
            DataManager.getSingleton().getParams().setCurrentPath(this.file.getParentFile());
        }
        catch (IOException ioe) {
            System.out.println("erreur");
        }
    }

    public void splitSource(String sep, char dec) {
        Iterator<String> it = this.lineFileImportDataOld.iterator();
        Vector<String> tempo = new Vector<String>();
        while (it.hasNext()) {
            String[] tabLigneFichier = it.next().split(sep);
            if (tabLigneFichier.length <= 0) continue;
            StringBuilder line = new StringBuilder(tabLigneFichier[0].trim());
            int i = 1;
            while (i < tabLigneFichier.length) {
                String elem = tabLigneFichier[i].trim();
                if (elem.length() > 0) {
                    if (dec == ',' && elem.indexOf(dec) != -1) {
                        try {
                            String elembis = elem.replace(dec, '.');
                            Integer.parseInt(elem);
                            elem = elembis;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    line.append("|" + elem);
                }
                ++i;
            }
            if (line.length() <= 0) continue;
            tempo.add(line.toString());
        }
        this.lineFileImportDataNew = tempo;
        this.elemFileNew.setListData(this.lineFileImportDataNew);
    }

    /*
     * WARNING - void declaration
     */
    public void setJTable(String sep, char dec, String txtmark) {
        void var9_15;
        if (sep.equals("|")) {
            sep = "\\|";
        }
        boolean istxtmarkgiven = txtmark.length() > 0;
        Iterator<String> it = this.lineFileImportDataOld.iterator();
        Vector tempo = new Vector();
        while (it.hasNext()) {
            String[] tabLigneFichier = it.next().split(sep);
            if (tabLigneFichier.length <= 0) continue;
            Vector<Object> line = new Vector<Object>();
            int n = 0;
            while (n < tabLigneFichier.length) {
                Object elem = tabLigneFichier[n].trim();
                if (((String)elem).length() > 0) {
                    if (istxtmarkgiven && ((String)elem).startsWith(txtmark) && ((String)elem).endsWith(txtmark)) {
                        elem = ((String)elem).substring(1, ((String)elem).length() - 1);
                    } else if (dec == ',' && ((String)elem).indexOf(dec) != -1) {
                        try {
                            String elembis = ((String)elem).replace(dec, '.');
                            Float.parseFloat(elembis);
                            elem = elembis;
                        }
                        catch (NumberFormatException nfe) {
                            System.out.println(nfe + (String)elem);
                        }
                    }
                    line.add(elem);
                }
                ++n;
            }
            if (line.size() <= 0) continue;
            tempo.add(line);
        }
        int numlines = tempo.size();
        int numcols = 0;
        for (Vector vector : tempo) {
            if (vector.size() <= numcols) continue;
            numcols = vector.size();
        }
        this.rowData = new Object[numlines][numcols + 1];
        boolean bl = false;
        while (var9_15 < numlines) {
            Vector line = (Vector)tempo.get((int)var9_15);
            this.rowData[var9_15][0] = (int)(var9_15 + true);
            int col = 1;
            for (Object o : line) {
                this.rowData[var9_15][col] = o;
                ++col;
            }
            while (col < numcols) {
                this.rowData[var9_15][col] = "";
                ++col;
            }
            ++var9_15;
        }
        Object[] objectArray = new String[numcols + 1];
        objectArray[0] = "";
        int col = 1;
        while (col <= numcols) {
            objectArray[col] = "" + col;
            ++col;
        }
        JTable jt = new JTable(this.rowData, objectArray);
        jt.setAutoResizeMode(0);
        this.oldScrollScript.setViewportView(jt);
        jt.setFillsViewportHeight(true);
    }

    private void filterTable(int lineFrom, int lineTo, int colFrom, int colTo, boolean flipLC, int ldescr, int compFrom, int compTo) {
        int i;
        CharSequence line;
        boolean[] numcol = null;
        if (lineFrom == -1) {
            lineFrom = 0;
            lineTo = this.rowData.length - 1;
        } else {
            --lineFrom;
            --lineTo;
        }
        if (colFrom == -1) {
            colFrom = 1;
            colTo = this.rowData[lineFrom].length - 1;
        }
        this.nbLines = lineTo - lineFrom + 1;
        this.nbCols = colTo - colFrom + 1;
        Vector<String> tempo = new Vector<String>();
        if (flipLC) {
            int tmp = this.nbLines;
            this.nbLines = this.nbCols;
            this.nbCols = tmp;
            numcol = new boolean[this.nbCols];
            Arrays.fill(numcol, true);
            int i2 = colFrom;
            while (i2 <= colTo) {
                String next = (String)this.rowData[lineFrom][i2];
                if (numcol[0]) {
                    try {
                        Float.parseFloat(next);
                    }
                    catch (NumberFormatException nfe) {
                        numcol[0] = false;
                    }
                }
                StringBuilder line2 = new StringBuilder(next);
                int j = lineFrom + 1;
                while (j <= lineTo) {
                    next = (String)this.rowData[j][i2];
                    if (numcol[j - lineFrom]) {
                        try {
                            Float.parseFloat(next);
                        }
                        catch (NumberFormatException nfe) {
                            numcol[j - lineFrom] = false;
                        }
                    }
                    line2.append("|" + next);
                    ++j;
                }
                tempo.add(line2.toString());
                ++i2;
            }
        } else {
            numcol = new boolean[this.nbCols];
            Arrays.fill(numcol, true);
            int i3 = lineFrom;
            while (i3 <= lineTo) {
                String next = (String)this.rowData[i3][colFrom];
                if (numcol[0]) {
                    try {
                        Float.parseFloat(next);
                    }
                    catch (NumberFormatException nfe) {
                        numcol[0] = false;
                    }
                }
                line = new StringBuilder(next);
                int j = colFrom + 1;
                while (j <= colTo) {
                    next = (String)this.rowData[i3][j];
                    if (numcol[j - colFrom]) {
                        try {
                            Float.parseFloat(next);
                        }
                        catch (NumberFormatException nfe) {
                            numcol[j - colFrom] = false;
                        }
                        catch (Exception e) {
                            System.out.println("unhandled exception at [" + i3 + "][" + j + "] : " + e);
                        }
                    }
                    line.append("|" + next);
                    ++j;
                }
                tempo.add(line.toString());
                ++i3;
            }
        }
        this.lineFileImportDataNew = tempo;
        StringBuilder lineDescr = null;
        if (ldescr != -1) {
            if (!flipLC) {
                lineDescr = new StringBuilder(String.valueOf((String)this.rowData[--ldescr][colFrom]) + (numcol[0] ? "" : ".S"));
                i = colFrom + 1;
                while (i <= colTo) {
                    lineDescr.append("|" + (String)this.rowData[ldescr][i] + (numcol[i - colFrom] ? "" : ".S"));
                    ++i;
                }
            } else {
                lineDescr = new StringBuilder(String.valueOf((String)this.rowData[lineFrom][ldescr]) + (numcol[0] ? "" : ".S"));
                i = lineFrom + 1;
                while (i <= lineTo) {
                    lineDescr.append("|" + (String)this.rowData[i][ldescr] + (numcol[i - lineFrom] ? "" : ".S"));
                    ++i;
                }
            }
        } else {
            lineDescr = new StringBuilder(numcol[0] ? "D0" : "D0.S");
            i = 1;
            while (i < this.nbCols) {
                lineDescr.append("|" + (numcol[i] ? "D" + i : "D" + i + ".S"));
                ++i;
            }
        }
        this.lineFileImportDataNew.add(0, lineDescr.toString());
        if (compFrom != -1) {
            this.nbAttrComp = compTo - compFrom + 1;
            int nl = 0;
            while (nl < this.lineFileImportDataNew.size() - 1) {
                line = this.lineFileImportDataNew.get(nl + 1);
                int crd = compFrom;
                while (crd <= compTo) {
                    line = String.valueOf(line) + "|" + (flipLC ? this.rowData[crd - 1][colFrom + nl] : this.rowData[lineFrom + nl][crd]);
                    ++crd;
                }
                this.lineFileImportDataNew.set(nl + 1, (String)line);
                ++nl;
            }
            String line3 = this.lineFileImportDataNew.get(0);
            if (ldescr != -1) {
                int crd = compFrom;
                while (crd <= compTo) {
                    line3 = String.valueOf(line3) + "|" + (flipLC ? this.rowData[crd - 1][ldescr] : this.rowData[ldescr][crd]);
                    ++crd;
                }
            } else {
                int nc = compFrom;
                while (nc <= compTo) {
                    line3 = String.valueOf(line3) + "|C" + (nc - compFrom);
                    ++nc;
                }
            }
            this.lineFileImportDataNew.set(0, line3);
        } else {
            this.nbAttrComp = 0;
        }
        this.elemFileNew.setListData(this.lineFileImportDataNew);
    }

    protected void end() {
        this.setVisible(false);
    }

    public void save(File filesave) {
        if (filesave == null) {
            URL u = this.parent.getParam().getCurrentPath();
            String path = null;
            path = u.getProtocol().equals("file") ? u.getPath() : System.getProperty("user.dir");
            JFileChooser chooser = new JFileChooser(path);
            int returnVal = chooser.showSaveDialog(null);
            if (returnVal == 0) {
                filesave = chooser.getSelectedFile();
                this.parent.getParam().setCurrentPath(filesave.getParentFile());
            }
        }
        if (filesave != null) {
            try {
                FileWriter fileWriter = new FileWriter(filesave);
                int i = 0;
                while (i < this.lineFileImportDataNew.size()) {
                    fileWriter.append(String.valueOf(this.lineFileImportDataNew.get(i)) + "\n");
                    ++i;
                }
                fileWriter.close();
            }
            catch (IOException err) {
                err.printStackTrace();
            }
            this.change = true;
            this.file = filesave;
        }
    }

    private void load() {
        if (this.standalone) {
            try {
                this.parent.loadInternal(DataManager.getDataType(this.file), new URL("file://" + this.file.getCanonicalPath()));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, Messages.getString("filenotagree"), Messages.getString("warning"), 2);
            }
        }
        this.setVisible(false);
    }

    private void saveandload(File f) {
        this.save(f);
        this.load();
    }

    public void delete() {
        if (this.elemFileNew.getSelectedIndex() >= 0 && this.lineFileImportDataNew.size() > 0) {
            this.lineFileImportDataNew.remove(this.elemFileNew.getSelectedIndex());
            this.update();
        }
    }

    public void cancel() {
        int taille = this.historique.size();
        if (taille >= 2) {
            int tailleOld = this.lineFileImportDataNew.size();
            int tailleNew = this.historique.get(taille - 2).size();
            int i = tailleOld - 1;
            while (i >= 0) {
                this.lineFileImportDataNew.remove(i);
                --i;
            }
            int j = 0;
            while (j < tailleNew) {
                this.lineFileImportDataNew.add(this.historique.get(taille - 2).get(j));
                ++j;
            }
            this.historique.remove(taille - 1);
        } else if (taille == 1) {
            int tailleOld = this.lineFileImportDataNew.size();
            int tailleNew = this.lineFileImportDataOld.size();
            int i = tailleOld - 1;
            while (i >= 0) {
                this.lineFileImportDataNew.remove(i);
                --i;
            }
            int j = 0;
            while (j < tailleNew) {
                this.lineFileImportDataNew.add(this.lineFileImportDataOld.get(j));
                ++j;
            }
            this.historique.remove(0);
        }
        this.elemFileNew.updateUI();
    }

    private void numberObjectsAttributes() {
        int attributes;
        int objects;
        this.nbElem = 0;
        try {
            objects = Integer.parseInt(this.lineFileImportDataNew.get(0));
            ++this.nbElem;
        }
        catch (Exception e) {
            objects = -1;
        }
        try {
            attributes = Integer.parseInt(this.lineFileImportDataNew.get(1));
            ++this.nbElem;
        }
        catch (Exception e) {
            attributes = -1;
        }
        this.numberObjectAttributes = new int[]{objects, attributes};
    }

    private void update() {
        this.elemFileNew.updateUI();
        this.historique.add((Vector)this.lineFileImportDataNew.clone());
        if (this.numberObjectAttributes[0] >= 0) {
            this.jtNbObjects.setText("" + this.numberObjectAttributes[0]);
        } else {
            this.jtNbObjects.setText("?");
        }
        if (this.numberObjectAttributes[1] >= 0) {
            this.jtNbAttributes.setText("" + this.numberObjectAttributes[1]);
        } else {
            this.jtNbAttributes.setText("?");
        }
        this.requestFocus();
    }

    @Override
    public void dispose() {
        this.removeAll();
        super.dispose();
    }

    public boolean getChange() {
        return this.change;
    }

    public String getSavedName() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    class BoxedPanel
    extends JPanel {
        private String title;

        BoxedPanel(String title) {
            this.setLayout(new BoxLayout(this, 3));
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }

    class JbInverseObAtt
    implements ActionListener {
        String s;

        JbInverseObAtt() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.s = ToolImportData.this.jtNbAttributes.getText();
            ToolImportData.this.jtNbAttributes.setText(ToolImportData.this.jtNbObjects.getText());
            ToolImportData.this.jtNbObjects.setText(this.s);
        }
    }

    class JbNbObAtt
    implements ActionListener {
        JbNbObAtt() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String objects = ToolImportData.this.jtNbObjects.getText();
            String attributes = ToolImportData.this.jtNbAttributes.getText();
            if (ToolImportData.this.nbElem == 1 && !ToolImportData.this.ajoutObAtt) {
                ToolImportData.this.lineFileImportDataNew.remove(0);
            } else if (ToolImportData.this.nbElem == 2 || ToolImportData.this.ajoutObAtt) {
                ToolImportData.this.lineFileImportDataNew.remove(0);
                ToolImportData.this.lineFileImportDataNew.remove(0);
            }
            ToolImportData.this.lineFileImportDataNew.add(0, objects);
            ToolImportData.this.lineFileImportDataNew.add(1, attributes);
            ToolImportData.this.numberObjectsAttributes();
            ToolImportData.this.update();
            ToolImportData.this.ajoutObAtt = true;
        }
    }

    class Jbseparator
    implements ActionListener {
        Jbseparator() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String separator = null;
            String file = "";
            int i = 0;
            while (i < ToolImportData.this.lineFileImportDataNew.size()) {
                file = String.valueOf(file) + (String)ToolImportData.this.lineFileImportDataNew.get(i);
                ++i;
            }
            int j = ToolImportData.this.lineFileImportDataNew.size() - 1;
            while (j != -1) {
                ToolImportData.this.lineFileImportDataNew.remove(j);
                --j;
            }
            String[] elemfile = file.split(separator);
            int k = 0;
            while (k < elemfile.length) {
                ToolImportData.this.lineFileImportDataNew.add(elemfile[k]);
                ++k;
            }
            ToolImportData.this.jbseparator.setEnabled(false);
            ToolImportData.this.numberObjectsAttributes();
            ToolImportData.this.update();
        }
    }

    class MenuTIDActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ToolImportData.this.mnuFileExit) {
                ToolImportData.this.dispose();
            }
        }
    }

    class StepFive
    extends BoxedPanel {
        StepFive() {
            super(String.valueOf(Messages.getString("step")) + " 5" + Messages.getString("semicolumn") + Messages.getString("toolimport_step5_title"));
            JLabel jlLC = new JLabel(String.valueOf(Messages.getString("toolimport_step5_line1")) + ToolImportData.this.nbLines + Messages.getString("toolimport_step5_line2") + " " + ToolImportData.this.nbCols + " " + Messages.getString("toolimport_step5_line3") + " " + ToolImportData.this.nbAttrComp + " " + Messages.getString("toolimport_step5_line4"));
            jlLC.setForeground(Color.BLUE);
            this.add(jlLC);
            jlLC = ToolImportData.this.namesGiven ? new JLabel(Messages.getString("toolimport_step5_manualnames")) : new JLabel(Messages.getString("toolimport_step5_autonames"));
            jlLC.setForeground(Color.BLUE);
            this.add(jlLC);
            JButton jbOK = new JButton(Messages.getString("ok"));
            jbOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ToolImportData.this.lineFileImportDataNew.add(0, "" + ToolImportData.this.nbLines);
                    ToolImportData.this.lineFileImportDataNew.add(1, "" + ToolImportData.this.nbCols);
                    ToolImportData.this.lineFileImportDataNew.add(2, "|");
                    ToolImportData.this.elemFileNew.setListData(ToolImportData.this.lineFileImportDataNew);
                    ToolImportData.this.goTo(6);
                }
            });
            this.add(jbOK);
        }
    }

    class StepFour
    extends BoxedPanel {
        private JCheckBox jcbDirRow;
        private JCheckBox jcbDirCol;
        private JCheckBox jcbLinesAll;
        private JCheckBox jcbLinesSome;
        private JPanel jpLinesTF;
        private JTextField jtfLinesFrom;
        private JTextField jtfLinesTo;
        private JCheckBox jcbColsAll;
        private JCheckBox jcbColsSome;
        private JPanel jpColsTF;
        private JTextField jtfColsFrom;
        private JTextField jtfColsTo;
        private JCheckBox jcbAttrCompT;
        private JCheckBox jcbAttrCompF;
        private JPanel jpCompTF;
        private JTextField jtfCompFrom;
        private JTextField jtfCompTo;
        private JLabel jlCompFrom;
        private JLabel jlDescr;
        private JTextField jtfDescr;

        StepFour() {
            super(String.valueOf(Messages.getString("step")) + " 4" + Messages.getString("semicolumn") + Messages.getString("toolimport_step4_title"));
            StepFourActionListener s4al = new StepFourActionListener();
            if (ToolImportData.this.dataType == 0 || ToolImportData.this.dataType == 20) {
                JLabel jlDirection = new JLabel(String.valueOf(Messages.getString("toolimport_step4_objectdirection")) + Messages.getString("semicolumn"));
                jlDirection.setForeground(Color.BLUE);
                this.add(jlDirection);
                this.add(Box.createRigidArea(new Dimension(0, 10)));
                JPanel jpDirection = new JPanel(new FlowLayout(0, 10, 2));
                this.jcbDirRow = new JCheckBox(Messages.getString("toolimport_step4_lines"), true);
                this.jcbDirRow.addActionListener(s4al);
                jpDirection.add(this.jcbDirRow);
                this.jcbDirCol = new JCheckBox(Messages.getString("toolimport_step4_cols"), false);
                this.jcbDirCol.addActionListener(s4al);
                jpDirection.add(this.jcbDirCol);
                this.add(jpDirection);
                this.add(Box.createRigidArea(new Dimension(0, 20)));
            }
            Color cvf = new Color(0, 100, 0);
            JLabel jl = new JLabel(Messages.getString("toolimport_step4_line1"));
            jl.setForeground(cvf);
            this.add(jl);
            jl = new JLabel(Messages.getString("toolimport_step4_line2"));
            jl.setForeground(cvf);
            this.add(jl);
            jl = new JLabel(Messages.getString("toolimport_step4_line3"));
            jl.setForeground(cvf);
            this.add(jl);
            jl = new JLabel(Messages.getString("toolimport_step4_line4"));
            jl.setForeground(cvf);
            this.add(jl);
            this.add(Box.createRigidArea(new Dimension(0, 20)));
            JPanel jpzDescr = new JPanel();
            jpzDescr.setBorder(BorderFactory.createTitledBorder(Messages.getString("toolimport_step4_descrattr_title")));
            jpzDescr.setLayout(new BoxLayout(jpzDescr, 1));
            JLabel jlLC = new JLabel(String.valueOf(Messages.getString("toolimport_step4_descrattr")) + Messages.getString("semicolumn"));
            jlLC.setForeground(Color.BLUE);
            jpzDescr.add(jlLC);
            JPanel jpLines = new JPanel(new FlowLayout(0, 10, 2));
            this.jcbLinesAll = new JCheckBox(Messages.getString("toolimport_step4_linesall"), true);
            this.jcbLinesAll.addActionListener(s4al);
            jpLines.add(this.jcbLinesAll);
            this.jcbLinesSome = new JCheckBox(Messages.getString("toolimport_step4_linessubset"), false);
            this.jcbLinesSome.addActionListener(s4al);
            jpLines.add(this.jcbLinesSome);
            this.jpLinesTF = new JPanel(new FlowLayout(0, 10, 2));
            this.jpLinesTF.add(new JLabel(String.valueOf(Messages.getString("from")) + Messages.getString("semicolumn")));
            this.jtfLinesFrom = new JTextField(5);
            this.jpLinesTF.add(this.jtfLinesFrom);
            this.jpLinesTF.add(new JLabel(String.valueOf(Messages.getString("to")) + Messages.getString("semicolumn")));
            this.jtfLinesTo = new JTextField(5);
            this.jpLinesTF.add(this.jtfLinesTo);
            this.jpLinesTF.setVisible(false);
            jpLines.add(this.jpLinesTF);
            jpLines.setAlignmentX(0.0f);
            jpzDescr.add(jpLines);
            JPanel jpCols = new JPanel(new FlowLayout(0, 10, 2));
            this.jcbColsAll = new JCheckBox(Messages.getString("toolimport_step4_colsall"), true);
            this.jcbColsAll.addActionListener(s4al);
            jpCols.add(this.jcbColsAll);
            this.jcbColsSome = new JCheckBox(Messages.getString("toolimport_step4_colssubset"), false);
            this.jcbColsSome.addActionListener(s4al);
            jpCols.add(this.jcbColsSome);
            this.jpColsTF = new JPanel(new FlowLayout(0, 10, 2));
            this.jpColsTF.add(new JLabel(String.valueOf(Messages.getString("from")) + Messages.getString("semicolumn")));
            this.jtfColsFrom = new JTextField(5);
            this.jpColsTF.add(this.jtfColsFrom);
            this.jpColsTF.add(new JLabel(String.valueOf(Messages.getString("to")) + Messages.getString("semicolumn")));
            this.jtfColsTo = new JTextField(5);
            this.jpColsTF.add(this.jtfColsTo);
            this.jpColsTF.setVisible(false);
            jpCols.add(this.jpColsTF);
            jpCols.setAlignmentX(0.0f);
            jpzDescr.add(jpCols);
            Component[] componentArray = jpzDescr.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                ((JComponent)c).setAlignmentX(0.0f);
                ++n2;
            }
            this.add(jpzDescr);
            this.add(Box.createRigidArea(new Dimension(0, 20)));
            JPanel jpzComp = new JPanel();
            jpzComp.setBorder(BorderFactory.createTitledBorder(Messages.getString("toolimport_step4_compattr_title")));
            jpzComp.setLayout(new BoxLayout(jpzComp, 1));
            JPanel jpCompFlow = new JPanel(new FlowLayout(0, 10, 2));
            jl = new JLabel(String.valueOf(Messages.getString("toolimport_step4_compattr")) + Messages.getString("semicolumn"));
            jl.setForeground(Color.BLUE);
            jpCompFlow.add(jl);
            this.jcbAttrCompT = new JCheckBox(Messages.getString("yes"), false);
            this.jcbAttrCompT.addActionListener(s4al);
            jpCompFlow.add(this.jcbAttrCompT);
            this.jcbAttrCompF = new JCheckBox(Messages.getString("no"), true);
            this.jcbAttrCompF.addActionListener(s4al);
            jpCompFlow.add(this.jcbAttrCompF);
            this.jpCompTF = new JPanel(new FlowLayout(0, 10, 2));
            this.jlCompFrom = new JLabel(String.valueOf(Messages.getString("cols")) + " " + Messages.getString("from") + Messages.getString("semicolumn"));
            this.jpCompTF.add(this.jlCompFrom);
            this.jtfCompFrom = new JTextField(5);
            this.jpCompTF.add(this.jtfCompFrom);
            this.jpCompTF.add(new JLabel(String.valueOf(Messages.getString("to")) + Messages.getString("semicolumn")));
            this.jtfCompTo = new JTextField(5);
            this.jpCompTF.add(this.jtfCompTo);
            this.jpCompTF.setVisible(false);
            jpCompFlow.add(this.jpCompTF);
            jpCompFlow.setAlignmentX(0.0f);
            jpzComp.add(jpCompFlow);
            jpzComp.add(Box.createRigidArea(new Dimension(0, 10)));
            Component[] componentArray2 = jpzComp.getComponents();
            int n3 = componentArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Component c = componentArray2[n4];
                ((JComponent)c).setAlignmentX(0.0f);
                ++n4;
            }
            this.add(jpzComp);
            if (ToolImportData.this.dataType == 0 || ToolImportData.this.dataType == 20) {
                JPanel jpzNames = new JPanel();
                jpzNames.setBorder(BorderFactory.createTitledBorder(Messages.getString("toolimport_step4_attrname_title")));
                jpzNames.setLayout(new BoxLayout(jpzNames, 1));
                this.jlDescr = new JLabel(Messages.getString("toolimport_step4_attrname_line1"));
                this.jlDescr.setForeground(Color.BLUE);
                jpzNames.add(this.jlDescr);
                JPanel jpDescr = new JPanel(new FlowLayout(0, 10, 2));
                this.jlDescr = new JLabel(String.valueOf(Messages.getString("toolimport_step4_attrname_line2")) + Messages.getString("semicolumn"));
                jpDescr.add(this.jlDescr);
                this.jtfDescr = new JTextField(5);
                jpDescr.add(this.jtfDescr);
                jpzNames.add(jpDescr);
                Component[] componentArray3 = jpzNames.getComponents();
                int n5 = componentArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    Component c = componentArray3[n6];
                    ((JComponent)c).setAlignmentX(0.0f);
                    ++n6;
                }
                this.add(Box.createRigidArea(new Dimension(0, 20)));
                this.add(jpzNames);
            }
            this.add(Box.createRigidArea(new Dimension(0, 30)));
            JButton jbOk = new JButton(Messages.getString("validate"));
            jbOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int lf = -1;
                    int lt = -1;
                    int cf = -1;
                    int ct = -1;
                    int compf = -1;
                    int compt = -1;
                    if (StepFour.this.jcbLinesSome.isSelected()) {
                        lf = Integer.parseInt(StepFour.this.jtfLinesFrom.getText());
                        lt = Integer.parseInt(StepFour.this.jtfLinesTo.getText());
                    }
                    if (StepFour.this.jcbColsSome.isSelected()) {
                        cf = Integer.parseInt(StepFour.this.jtfColsFrom.getText());
                        ct = Integer.parseInt(StepFour.this.jtfColsTo.getText());
                    }
                    if (StepFour.this.jcbAttrCompT.isSelected()) {
                        compf = Integer.parseInt(StepFour.this.jtfCompFrom.getText());
                        compt = Integer.parseInt(StepFour.this.jtfCompTo.getText());
                    }
                    String ldstr = StepFour.this.jtfDescr.getText();
                    int ldint = -1;
                    if (ldstr.length() > 0) {
                        try {
                            ldint = Integer.parseInt(ldstr);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    ToolImportData.this.filterTable(lf, lt, cf, ct, StepFour.this.jcbDirCol.isSelected(), ldint, compf, compt);
                    ToolImportData.this.namesGiven = ldint != -1;
                    ToolImportData.this.goTo(5);
                }
            });
            this.add(jbOk);
        }

        class StepFourActionListener
        implements ActionListener {
            StepFourActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCheckBox jcb = (JCheckBox)arg0.getSource();
                if (jcb == StepFour.this.jcbLinesAll) {
                    StepFour.this.jcbLinesSome.setSelected(!StepFour.this.jcbLinesAll.isSelected());
                    StepFour.this.jpLinesTF.setVisible(StepFour.this.jcbLinesSome.isSelected());
                } else if (jcb == StepFour.this.jcbLinesSome) {
                    StepFour.this.jcbLinesAll.setSelected(!StepFour.this.jcbLinesSome.isSelected());
                    StepFour.this.jpLinesTF.setVisible(StepFour.this.jcbLinesSome.isSelected());
                } else if (jcb == StepFour.this.jcbColsAll) {
                    StepFour.this.jcbColsSome.setSelected(!StepFour.this.jcbColsAll.isSelected());
                    StepFour.this.jpColsTF.setVisible(StepFour.this.jcbColsSome.isSelected());
                } else if (jcb == StepFour.this.jcbColsSome) {
                    StepFour.this.jcbColsAll.setSelected(!StepFour.this.jcbColsSome.isSelected());
                    StepFour.this.jpColsTF.setVisible(StepFour.this.jcbColsSome.isSelected());
                } else if (jcb == StepFour.this.jcbDirRow) {
                    StepFour.this.jcbDirCol.setSelected(!StepFour.this.jcbDirRow.isSelected());
                    this.setJLDescr(StepFour.this.jcbDirRow.isSelected());
                } else if (jcb == StepFour.this.jcbDirCol) {
                    StepFour.this.jcbDirRow.setSelected(!StepFour.this.jcbDirCol.isSelected());
                    this.setJLDescr(StepFour.this.jcbDirRow.isSelected());
                } else if (jcb == StepFour.this.jcbAttrCompT) {
                    StepFour.this.jcbAttrCompF.setSelected(!StepFour.this.jcbAttrCompT.isSelected());
                    StepFour.this.jpCompTF.setVisible(StepFour.this.jcbAttrCompT.isSelected());
                } else if (jcb == StepFour.this.jcbAttrCompF) {
                    StepFour.this.jcbAttrCompT.setSelected(!StepFour.this.jcbAttrCompF.isSelected());
                    StepFour.this.jpCompTF.setVisible(StepFour.this.jcbAttrCompT.isSelected());
                }
                ToolImportData.this.pack();
            }

            private void setJLDescr(boolean dirRow) {
                if (dirRow) {
                    StepFour.this.jlDescr.setText(String.valueOf(Messages.getString("toolimport_step4_attrname_line2")) + Messages.getString("semicolumn"));
                    StepFour.this.jlCompFrom.setText(String.valueOf(Messages.getString("cols")) + " " + Messages.getString("from") + Messages.getString("semicolumn"));
                } else {
                    StepFour.this.jlDescr.setText(String.valueOf(Messages.getString("toolimport_step4_attrname_line3")) + Messages.getString("semicolumn"));
                    StepFour.this.jlCompFrom.setText(String.valueOf(Messages.getString("lines")) + " " + Messages.getString("from") + Messages.getString("semicolumn"));
                }
            }
        }
    }

    class StepOne
    extends BoxedPanel {
        StepOne() {
            super(String.valueOf(Messages.getString("step")) + " 1" + Messages.getString("semicolumn") + Messages.getString("toolimport_step1_title"));
            this.add(new JLabel(Messages.getString("toolimport_welcome")));
            this.add(Box.createRigidArea(new Dimension(0, 20)));
            this.add(new JLabel(Messages.getString("toolimport_step1_line1")));
            this.add(Box.createRigidArea(new Dimension(0, 20)));
            this.add(new JLabel(Messages.getString("toolimport_step1_line2")));
            this.add(new JLabel(Messages.getString("toolimport_step1_line3")));
            this.add(new JLabel(Messages.getString("toolimport_step1_line4")));
            JButton jbLoad = new JButton(Messages.getString("load"));
            jbLoad.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    if (ToolImportData.this.loadSource()) {
                        ToolImportData.this.goTo(2);
                    }
                }
            });
            this.add(jbLoad);
        }
    }

    class StepSix
    extends BoxedPanel {
        private JButton jbSave;
        private JButton jbLoad;

        StepSix() {
            super(String.valueOf(Messages.getString("step")) + " 6" + Messages.getString("semicolumn") + Messages.getString("toolimport_step6_title"));
            this.add(new JLabel(Messages.getString("toolimport_step6_line1")));
            if (ToolImportData.this.standalone) {
                this.add(new JLabel(String.valueOf(Messages.getString("toolimport_step6_choose")) + Messages.getString("semicolumn")));
            }
            StepSixActionListener ssal = new StepSixActionListener();
            JPanel jpButtons = new JPanel(new FlowLayout());
            this.jbSave = new JButton(Messages.getString("save"));
            this.jbSave.addActionListener(ssal);
            jpButtons.add(this.jbSave);
            if (ToolImportData.this.standalone) {
                this.jbLoad = new JButton(Messages.getString("saveandload"));
                this.jbLoad.addActionListener(ssal);
                jpButtons.add(this.jbLoad);
            }
            this.add(jpButtons);
        }

        class StepSixActionListener
        implements ActionListener {
            StepSixActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == StepSix.this.jbSave) {
                    ToolImportData.this.save(null);
                    ToolImportData.this.end();
                } else if (e.getSource() == StepSix.this.jbLoad) {
                    ToolImportData.this.saveandload(null);
                }
            }
        }
    }

    class StepThree
    extends BoxedPanel {
        public StepThree() {
            super(String.valueOf(Messages.getString("step")) + " 3" + Messages.getString("semicolumn") + Messages.getString("toolimport_step3_title"));
            this.add(new JLabel(String.valueOf(Messages.getString("toolimport_step3_content")) + Messages.getString("semicolumn")));
            JButton jbAttrVal = new JButton(Messages.getString("toolimport_step3_attrval"));
            jbAttrVal.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    ToolImportData.this.dataType = 0;
                    ToolImportData.this.goTo(4);
                }
            });
            this.add(jbAttrVal);
            JButton jbMatrix = new JButton(Messages.getString("toolimport_step3_dist"));
            jbMatrix.setEnabled(false);
            jbMatrix.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    ToolImportData.this.dataType = 10;
                    ToolImportData.this.goTo(4);
                }
            });
            this.add(jbMatrix);
            JButton jb3D = new JButton(Messages.getString("toolimport_step3_3d"));
            jb3D.setEnabled(false);
            jb3D.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    ToolImportData.this.dataType = 20;
                    ToolImportData.this.goTo(4);
                }
            });
            this.add(jb3D);
        }
    }

    class StepTwo
    extends BoxedPanel {
        private JComboBox jcd;
        private JComboBox jcs;
        private JComboBox jct;
        private JTextField jtSeparator;

        public StepTwo() {
            super(String.valueOf(Messages.getString("step")) + " 2" + Messages.getString("semicolumn") + Messages.getString("toolimport_step2_title"));
            JLabel jl = new JLabel(String.valueOf(Messages.getString("toolimport_step2_sourcefile")) + Messages.getString("semicolumn"));
            jl.setAlignmentX(0.0f);
            this.add(jl);
            JScrollPane sourceScrollScript = new JScrollPane(ToolImportData.this.elemFileOld);
            sourceScrollScript.setPreferredSize(new Dimension(300, 200));
            sourceScrollScript.setVisible(true);
            this.add(sourceScrollScript);
            this.add(Box.createRigidArea(new Dimension(0, 30)));
            jl = new JLabel(String.valueOf(Messages.getString("toolimport_step2_fieldseparator")) + Messages.getString("semicolumn"));
            jl.setAlignmentX(0.0f);
            this.add(jl);
            this.jcs = new JComboBox<Object>(new Object[]{"[" + Messages.getString("space") + "]", "[" + Messages.getString("tab") + "]", ";", ":", "|", Messages.getString("other")});
            this.jcs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    StepTwo.this.jtSeparator.setVisible(((JComboBox)arg0.getSource()).getSelectedItem().equals(Messages.getString("other")));
                }
            });
            this.add(this.jcs);
            this.jtSeparator = new JTextField(3);
            this.jtSeparator.setVisible(false);
            this.add(this.jtSeparator);
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            jl = new JLabel(String.valueOf(Messages.getString("toolimport_step2_decsymb")) + Messages.getString("semicolumn"));
            jl.setAlignmentX(0.0f);
            this.add(jl);
            this.jcd = new JComboBox<Object>(new Object[]{",", "."});
            this.add(this.jcd);
            jl = new JLabel(String.valueOf(Messages.getString("toolimport_step2_textseparator")) + Messages.getString("semicolumn"));
            jl.setAlignmentX(0.0f);
            this.add(jl);
            this.jct = new JComboBox<Object>(new Object[]{"\"", "'", ""});
            this.add(this.jct);
            this.add(Box.createRigidArea(new Dimension(0, 30)));
            JButton jbOk = new JButton(Messages.getString("validate"));
            jbOk.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    String sep = null;
                    if (StepTwo.this.jtSeparator.isVisible()) {
                        sep = StepTwo.this.jtSeparator.getText();
                    } else {
                        sep = (String)StepTwo.this.jcs.getSelectedItem();
                        if (sep.equals("[" + Messages.getString("space") + "]")) {
                            sep = " ";
                        } else if (sep.equals("[" + Messages.getString("tab") + "]")) {
                            sep = "\t";
                        }
                    }
                    ToolImportData.this.setJTable(sep, ((String)StepTwo.this.jcd.getSelectedItem()).charAt(0), (String)StepTwo.this.jct.getSelectedItem());
                    ToolImportData.this.goTo(3);
                }
            });
            this.add(jbOk);
        }
    }

    class TILabel
    extends JLabel {
        public TILabel(String txt) {
            super(txt);
            this.setAlignmentX(0.0f);
        }
    }
}

