/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import javax.swing.JFrame;
import lib3d4j.international.Messages;

public class VoronoiPanel
extends JFrame {
    private static final long serialVersionUID = 1L;
    private LinkedList<Poly> l;
    private int refP = -1;

    public VoronoiPanel() {
        this.init();
    }

    public void setText(String s) {
        this.setTitle(String.valueOf(Messages.getString("voronoi_title")) + " - " + s);
    }

    public void setRefPoint(int p) {
        this.refP = p;
    }

    public void addPolygon(Polygon p, Point2D pnt, int c) {
        proxyPolygon d = new proxyPolygon(p, pnt, c);
        this.l.add(d);
    }

    public void addPolygon(Polygon p, Point2D pnt1, Point2D pnt2, int c) {
        System.out.println("add polygon " + p + " " + pnt1 + " " + pnt2 + " " + c);
        distPolygon d = new distPolygon(p, pnt1, pnt2, c);
        this.l.add(d);
    }

    @Override
    public void paint(Graphics g) {
        int i = 0;
        for (Object e : this.l) {
            Polygon p;
            int c;
            if (e.getClass() == distPolygon.class) {
                c = ((distPolygon)e).getColor();
                g.setColor(new Color(c, c, c));
                p = ((distPolygon)e).getPolygon();
                g.fillPolygon(p);
                g.setColor(Color.black);
                g.drawPolygon(p);
                continue;
            }
            c = ((proxyPolygon)e).getColor();
            g.setColor(new Color(c, c, c));
            p = ((proxyPolygon)e).getPolygon();
            g.fillPolygon(p);
            g.setColor(Color.black);
            g.drawPolygon(p);
            Point2D pnt = ((proxyPolygon)e).getPoint();
            g.setColor(Color.white);
            g.fillOval((int)pnt.getX() - 2, (int)pnt.getY() - 2, 5, 5);
        }
        for (Object e : this.l) {
            if (e.getClass() == distPolygon.class) {
                Point2D pnt1 = ((distPolygon)e).getPoint1();
                g.setColor(Color.red);
                g.fillOval((int)pnt1.getX() - 5, (int)pnt1.getY() - 5, 10, 10);
                g.setColor(Color.black);
                g.drawOval((int)pnt1.getX() - 5, (int)pnt1.getY() - 5, 10, 10);
                continue;
            }
            Point2D pnt = ((proxyPolygon)e).getPoint();
            if (this.refP != i) {
                g.setColor(Color.black);
                g.drawOval((int)pnt.getX() - 2, (int)pnt.getY() - 2, 5, 5);
            } else {
                g.setColor(Color.red);
                g.drawOval((int)pnt.getX() - 2, (int)pnt.getY() - 2, 5, 5);
                g.drawOval((int)pnt.getX() - 3, (int)pnt.getY() - 3, 7, 7);
            }
            ++i;
        }
    }

    private void init() {
        this.setTitle("Cellules de Voronoi");
        this.l = new LinkedList();
    }

    private class Poly {
        private Poly() {
        }
    }

    private class distPolygon
    extends Poly {
        private Polygon pol;
        private Point2D p1;
        private Point2D p2;
        private int col;

        public distPolygon(Polygon pol, Point2D p1, Point2D p2, int col) {
            this.pol = pol;
            this.p1 = p1;
            this.p2 = p2;
            this.col = col;
        }

        public Polygon getPolygon() {
            return this.pol;
        }

        public Point2D getPoint1() {
            return this.p1;
        }

        public Point2D getPoint2() {
            return this.p2;
        }

        public int getColor() {
            return this.col;
        }
    }

    private class proxyPolygon
    extends Poly {
        private Polygon pol;
        private Point2D p;
        private int col;

        public proxyPolygon(Polygon pol, Point2D p, int col) {
            this.pol = pol;
            this.p = p;
            this.col = col;
        }

        public Polygon getPolygon() {
            return this.pol;
        }

        public Point2D getPoint() {
            return this.p;
        }

        public int getColor() {
            return this.col;
        }
    }
}

