/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.compute.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lib3d4j.data.Coordinates;

public class Envelope3D {
    private List<float[]> remain;
    private List<int[][]> edges;
    private List<int[][]> sides;
    private int nbpt;

    public Envelope3D(Coordinates d3d) {
        this(d3d.tab3D);
    }

    public Envelope3D(float[][] tab3D) {
        this.nbpt = tab3D.length;
        this.remain = new ArrayList<float[]>();
        float[][] fArray = tab3D;
        int n = tab3D.length;
        int n2 = 0;
        while (n2 < n) {
            float[] p = fArray[n2];
            this.remain.add(p);
            ++n2;
        }
    }

    public int[][] getConvexEnvelope() {
        this.edges = new ArrayList<int[][]>();
        this.sides = new ArrayList<int[][]>();
        int p1 = 0;
        float zp1 = this.remain.get(0)[2];
        int i = 1;
        while (i < this.nbpt) {
            if (this.remain.get(i)[2] < zp1) {
                zp1 = this.remain.get(i)[2];
                p1 = i;
            }
            ++i;
        }
        float[] pp1 = this.remain.get(p1);
        int p2 = 0;
        if (p1 == p2) {
            ++p2;
        }
        double ap1p2 = this.angleZ(pp1, this.remain.get(p2));
        int i2 = p2 + 1;
        while (i2 < this.nbpt) {
            double candidat;
            if (i2 != p1 && (candidat = this.angleZ(pp1, this.remain.get(i2))) < ap1p2) {
                ap1p2 = candidat;
                p2 = i2;
            }
            ++i2;
        }
        int p3 = this.nextFace(p1, p2);
        this.edges.add(this.createEdge(p1, p2, p3));
        this.edges.add(this.createEdge(p2, p3, p1));
        this.edges.add(this.createEdge(p3, p1, p2));
        this.sides.add(this.createEdge(p1, p2, p3));
        int current = 0;
        while (current < this.edges.size()) {
            int next;
            int[][] curEdge = this.edges.get(current);
            int[][] edge = this.createEdge(curEdge[0][0], next = this.nextFace(curEdge[0][0], curEdge[0][1], curEdge[0][2]), curEdge[0][1]);
            if (this.isNewEdge(edge)) {
                this.edges.add(edge);
            }
            if (this.isNewEdge(edge = this.createEdge(next, curEdge[0][1], curEdge[0][0]))) {
                this.edges.add(edge);
            }
            if (this.isNewEdge(edge = this.createEdge(curEdge[0][1], curEdge[0][0], next))) {
                this.sides.add(edge);
            }
            ++current;
        }
        int[][] ce = new int[this.sides.size()][];
        int i3 = 0;
        while (i3 < ce.length) {
            ce[i3] = this.sides.get(i3)[0];
            ++i3;
        }
        return ce;
    }

    private boolean isNewEdge(int[][] edge) {
        for (int[][] elem : this.sides) {
            if (elem[0][0] != edge[0][0] || elem[0][1] != edge[0][1] || elem[0][2] != edge[0][2]) continue;
            return false;
        }
        for (int[][] elem : this.edges) {
            if (elem[0][0] != edge[0][0] || elem[0][1] != edge[0][1] || elem[0][2] != edge[0][2]) continue;
            return false;
        }
        return true;
    }

    private int[][] createEdge(int p1, int p2, int p3) {
        int[][] res = new int[2][3];
        int n = p1;
        res[1][0] = n;
        res[0][0] = n;
        int n2 = p2;
        res[1][1] = n2;
        res[0][1] = n2;
        int n3 = p3;
        res[1][2] = n3;
        res[0][2] = n3;
        Arrays.sort(res[1]);
        return res;
    }

    private int nextFace(float[] pp1, float[] pp2, float[] pp3) {
        float[] vp1p2 = new float[3];
        int i = 0;
        while (i < 3) {
            vp1p2[i] = pp2[i] - pp1[i];
            ++i;
        }
        float[] vp1p3 = new float[3];
        int i2 = 0;
        while (i2 < 3) {
            vp1p3[i2] = pp3[i2] - pp1[i2];
            ++i2;
        }
        float[] n = this.orthoUnit(vp1p2, vp1p3);
        float[] k = this.orthoUnit(vp1p2, n);
        int p4 = 0;
        float cf = this.cosFaces(pp1, n, k, this.remain.get(0));
        int i3 = 1;
        while (i3 < this.nbpt) {
            float cftemp = this.cosFaces(pp1, n, k, this.remain.get(i3));
            if (cftemp < cf) {
                cf = cftemp;
                p4 = i3;
            }
            ++i3;
        }
        return p4;
    }

    private int nextFace(int p1, int p2, int p3) {
        float[] pp1 = this.remain.get(p1);
        float[] pp2 = this.remain.get(p2);
        float[] pp3 = this.remain.get(p3);
        float[] vp1p2 = new float[3];
        int i = 0;
        while (i < 3) {
            vp1p2[i] = pp2[i] - pp1[i];
            ++i;
        }
        float[] vp1p3 = new float[3];
        int i2 = 0;
        while (i2 < 3) {
            vp1p3[i2] = pp3[i2] - pp1[i2];
            ++i2;
        }
        float[] n = this.orthoUnit(vp1p2, vp1p3);
        float[] k = this.orthoUnit(n, vp1p2);
        int p4 = 0;
        while (p4 == p1 || p4 == p2) {
            ++p4;
        }
        float cf = this.cosFaces(pp1, n, k, this.remain.get(p4));
        int i3 = p4 + 1;
        while (i3 < this.nbpt) {
            float cftemp;
            if (i3 != p1 && i3 != p2 && (cftemp = this.cosFaces(pp1, n, k, this.remain.get(i3))) < cf) {
                cf = cftemp;
                p4 = i3;
            }
            ++i3;
        }
        return p4;
    }

    private int nextFace(int p1, int p2) {
        float[] pp1 = this.remain.get(p1);
        float[] pp2 = this.remain.get(p2);
        float[] pp3 = new float[]{pp1[0] + 1.0f, pp1[1], pp1[2]};
        int p4 = 0;
        float cf = 2.0f;
        int flip = 0;
        while (flip < 2) {
            float[] vp1p2 = new float[3];
            int i = 0;
            while (i < 3) {
                vp1p2[i] = pp2[i] - pp1[i];
                ++i;
            }
            float[] vp1p3 = new float[3];
            int i2 = 0;
            while (i2 < 3) {
                vp1p3[i2] = pp3[i2] - pp1[i2];
                ++i2;
            }
            float[] n = this.orthoUnit(vp1p2, vp1p3);
            float[] k = this.orthoUnit(vp1p2, n);
            int i3 = 0;
            while (i3 < this.nbpt) {
                float cftemp;
                if (i3 != p1 && i3 != p2 && (cftemp = this.cosFaces(pp1, n, k, this.remain.get(i3))) < cf) {
                    cf = cftemp;
                    p4 = i3;
                }
                ++i3;
            }
            pp3[0] = pp1[0] - 1.0f;
            ++flip;
        }
        return p4;
    }

    private float[] orthoUnit(float[] v1, float[] v2) {
        float[] ou = this.ortho(v1, v2);
        float length = (float)Math.sqrt(ou[0] * ou[0] + ou[1] * ou[1] + ou[2] * ou[2]);
        ou[0] = ou[0] / length;
        ou[1] = ou[1] / length;
        ou[2] = ou[2] / length;
        return ou;
    }

    private float[] ortho(float[] v1, float[] v2) {
        float[] o = new float[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
        return o;
    }

    private double angleZ(float[] p1, float[] p2) {
        double op = p2[2] - p1[2];
        double adj = Math.sqrt((p2[0] - p1[0]) * (p2[0] - p1[0]) + (p2[1] - p1[1]) * (p2[1] - p1[1]));
        return Math.atan(op / adj);
    }

    private float cosFaces(float[] p, float[] n, float[] k, float[] q) {
        float[] vpq = new float[3];
        int i = 0;
        while (i < 3) {
            vpq[i] = q[i] - p[i];
            ++i;
        }
        float num = vpq[0] * k[0] + vpq[1] * k[1] + vpq[2] * k[2];
        float den = vpq[0] * n[0] + vpq[1] * n[1] + vpq[2] * n[2];
        den = (float)Math.sqrt(den * den + num * num);
        return num / den;
    }

    public static void main(String[] args) {
        float[][] tt = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 5.0f, 5.0f}, {5.0f, 1.0f, 0.0f}, {0.0f, 10.0f, 0.0f}, {1.0f, 2.0f, 2.0f}};
        Coordinates test = new Coordinates(tt);
        Envelope3D ev = new Envelope3D(test);
        int[][] res = ev.getConvexEnvelope();
    }
}

