/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.compute.tools;

import Jama.Matrix;
import java.util.LinkedList;

public class OutilsTableaux {
    public static float[][] doubleToFloat(double[][] d) {
        float[][] f = new float[d.length][d[0].length];
        int i = 0;
        while (i < d.length) {
            int j = 0;
            while (j < d[0].length) {
                f[i][j] = (float)d[i][j];
                ++j;
            }
            ++i;
        }
        return f;
    }

    public static float[][] transpose(float[][] t) {
        int i = 0;
        while (i < t.length) {
            int j = i + 1;
            while (j < t.length) {
                float aux = t[i][j];
                t[i][j] = t[j][i];
                t[j][i] = aux;
                ++j;
            }
            ++i;
        }
        return t;
    }

    public static float colMean(float[][] t, int colonne) {
        float somme = 0.0f;
        int i = 0;
        while (i < t.length) {
            somme += t[i][colonne];
            ++i;
        }
        return somme / (float)t.length;
    }

    public static float mean(float[][] t) {
        float somme = 0.0f;
        int i = 0;
        while (i < t.length) {
            int j = 0;
            while (j < t[0].length) {
                somme += t[i][j];
                ++j;
            }
            ++i;
        }
        return somme / (float)(t.length * t[0].length);
    }

    public static float[] doubleToFloat(double[] d) {
        float[] f = new float[d.length];
        int i = 0;
        while (i < d.length) {
            f[i] = (float)d[i];
            ++i;
        }
        return f;
    }

    public static float[] multiplyByScalar(float[] t, float scalaire) {
        int i = 0;
        while (i < t.length) {
            int n = i++;
            t[n] = t[n] * scalaire;
        }
        return t;
    }

    public static float[][] multiplyByScalar(float[][] t, float scalaire) {
        int i = 0;
        while (i < t.length) {
            int j = 0;
            while (j < t[0].length) {
                float[] fArray = t[i];
                int n = j++;
                fArray[n] = fArray[n] * scalaire;
            }
            ++i;
        }
        return t;
    }

    public static float[][] multiplyByScalar(float[][] t, int col, float scalaire) {
        int i = 0;
        while (i < t.length) {
            float[] fArray = t[i];
            int n = col;
            fArray[n] = fArray[n] * scalaire;
            ++i;
        }
        return t;
    }

    public static double[][] floatToDouble(float[][] d) {
        double[][] f = new double[d.length][d[0].length];
        int i = 0;
        while (i < d.length) {
            int j = 0;
            while (j < d[0].length) {
                f[i][j] = d[i][j];
                ++j;
            }
            ++i;
        }
        return f;
    }

    public static double[] floatToDouble(float[] d) {
        double[] f = new double[d.length];
        int i = 0;
        while (i < d.length) {
            f[i] = d[i];
            ++i;
        }
        return f;
    }

    public static Matrix[] dropRow(int numero, Matrix[] tableau) {
        Matrix[] tmp = new Matrix[tableau.length - 1];
        int i = 0;
        while (i < numero) {
            tmp[i] = tableau[i];
            ++i;
        }
        i = numero + 1;
        while (i < tableau.length) {
            tmp[i - 1] = tableau[i];
            ++i;
        }
        return tmp;
    }

    public static float[] substractArrays(float[] g, float[] d) {
        int i = 0;
        while (i < g.length) {
            int n = i;
            g[n] = g[n] - d[i];
            ++i;
        }
        return g;
    }

    public static float[][] dropRow(int numero, float[][] tableau) {
        float[][] tmp = new float[tableau.length - 1][];
        int i = 0;
        while (i < numero) {
            tmp[i] = tableau[i];
            ++i;
        }
        i = numero + 1;
        while (i < tableau.length) {
            tmp[i - 1] = tableau[i];
            ++i;
        }
        return tmp;
    }

    public static float[][][] dropRow(int numero, float[][][] tableau) {
        float[][][] tmp = new float[tableau.length - 1][][];
        int i = 0;
        while (i < numero) {
            tmp[i] = tableau[i];
            ++i;
        }
        i = numero + 1;
        while (i < tableau.length) {
            tmp[i - 1] = tableau[i];
            ++i;
        }
        return tmp;
    }

    public static int[][] dropRow(int numero, int[][] tableau) {
        int[][] tmp = new int[tableau.length - 1][];
        int i = 0;
        while (i < numero) {
            tmp[i] = tableau[i];
            ++i;
        }
        i = numero + 1;
        while (i < tableau.length) {
            tmp[i - 1] = tableau[i];
            ++i;
        }
        return tmp;
    }

    public static Object[][] splitByIndex(Object[] donneeOriginale, int[] numerosObjets) {
        int max = numerosObjets[0];
        int i = 0;
        while (i < numerosObjets.length) {
            if (max < numerosObjets[i]) {
                max = numerosObjets[i];
            }
            ++i;
        }
        LinkedList[] l = new LinkedList[max];
        int i2 = 0;
        while (i2 < l.length) {
            l[i2] = new LinkedList();
            ++i2;
        }
        i2 = 0;
        while (i2 < donneeOriginale.length) {
            l[numerosObjets[i2]].add(donneeOriginale[i2]);
            ++i2;
        }
        Object[][] res = new Object[l.length][];
        int i3 = 0;
        while (i3 < res.length) {
            l[i3].toArray(res[i3]);
            ++i3;
        }
        return res;
    }

    public static Object[] subArray(Object[] tableau, int[] numerosConserves) {
        Object[] res = new Object[numerosConserves.length];
        int i = 0;
        while (i < numerosConserves.length) {
            res[i] = tableau[numerosConserves[i]];
            ++i;
        }
        return res;
    }

    public static float[][] subArray(float[][] tableau, int[] numerosConserves) {
        float[][] res = new float[numerosConserves.length][];
        int i = 0;
        while (i < numerosConserves.length) {
            res[i] = tableau[numerosConserves[i]];
            ++i;
        }
        return res;
    }

    public static boolean isIn(Object[] tab, Object obj) {
        int i = 0;
        while (i < tab.length) {
            if (tab[i] == obj) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIn(int[] tab, int obj) {
        int i = 0;
        while (i < tab.length) {
            if (tab[i] == obj) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

