/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import lib3d4j.data.DatasetParams;
import lib3d4j.international.Messages;

public class DescriptionData
extends Observable {
    protected String[] compAttrNames;
    protected float[][] data = null;
    protected List<List<Object>> symb = null;
    protected DatasetParams params = null;
    protected int nbDescrObjects;
    protected int nbatt;
    protected int[][] distrib = null;
    private List<Integer> tmpcols = new ArrayList<Integer>();
    protected boolean individualChange = true;

    public DescriptionData() {
        this.init();
    }

    public void reset() {
        this.init();
        this.notifyObservers();
    }

    private void init() {
        this.data = null;
        this.symb = new ArrayList<List<Object>>();
        if (this.params == null) {
            this.params = new DatasetParams();
        }
        this.nbDescrObjects = -1;
        this.nbatt = 0;
        this.compAttrNames = new String[this.nbatt];
        this.distrib = new int[this.nbatt][];
    }

    public DescriptionData(float[][] data, List<List<Object>> symb, DatasetParams params) {
        this.nbDescrObjects = data[0].length;
        this.nbatt = data.length;
        this.data = data;
        this.symb = symb;
        this.params = params;
    }

    public DatasetParams getParams() {
        return this.params;
    }

    public void setParams(DatasetParams params) {
        this.params = params;
    }

    public int getColumnIndex(String name) {
        int res = 0;
        while (res < this.nbatt) {
            if (name.equals(this.compAttrNames[res])) {
                return res;
            }
            ++res;
        }
        return -1;
    }

    public LinkedList<String> getListeNoms() {
        LinkedList<String> l = new LinkedList<String>();
        int i = 0;
        while (i < this.nbatt) {
            l.add(this.compAttrNames[i]);
            ++i;
        }
        return l;
    }

    public String[] getColNamesWithIndice() {
        String[] res = new String[this.nbatt + 1];
        res[0] = Messages.getString("indice");
        if (this.nbatt > 0) {
            System.arraycopy(this.compAttrNames, 0, res, 1, this.nbatt);
        }
        return res;
    }

    public String getColumnName(int rank) {
        return this.compAttrNames[rank];
    }

    public Object getFormValue(int i) {
        int fo = this.params.getFormCol();
        return this.symb.get(fo).get((int)this.data[fo][i]);
    }

    public int getFormIndice(int i) {
        int col = this.params.getFormCol();
        return (int)this.data[col][i];
    }

    public int getClassIndice(int i) {
        int col = this.params.getClassCol();
        return (int)this.data[col][i];
    }

    public int[] getClassIndices() {
        int col = this.params.getClassCol();
        int[] classes = new int[this.nbDescrObjects];
        int i = 0;
        while (i < this.nbDescrObjects) {
            classes[i] = (int)this.data[col][i];
            ++i;
        }
        return classes;
    }

    public int getNbClasses() {
        int col = this.params.getClassCol();
        return this.symb.get(col).size();
    }

    public float getColorValue(int i) {
        return this.data[this.params.getColorCol()][i];
    }

    public int getNbColor() {
        int col = this.params.getColorCol();
        return this.symb.get(col).size();
    }

    public int getNbDistinctVal(int col) {
        return this.symb.get(col).size();
    }

    public List<Object> getVectorColor() {
        return this.symb.get(this.params.getColorCol());
    }

    public boolean isSymbolicAttribute(int rank) {
        return this.symb.get(rank) != null;
    }

    public boolean isClassAttrGiven() {
        return this.params.getClassCol() != -1;
    }

    public boolean isPictureAttrGiven() {
        return this.params.getAssocDataCol() != -1;
    }

    public boolean isLabelAttrGiven() {
        return this.params.getLabelCol() != -1;
    }

    public boolean isColAttrGiven() {
        return this.params.getColorCol() != -1;
    }

    public int getColorIndice(int i) {
        int col = this.params.getColorCol();
        return (int)this.data[col][i];
    }

    public float[] getColorValues() {
        return this.data[this.params.getColorCol()];
    }

    public Object getAssocDataValue(int i) {
        int ad = this.params.getAssocDataCol();
        return this.symb.get(ad).get((int)this.data[ad][i]);
    }

    public Object getCompAttrValue(int i, int attr) {
        if (this.symb.get(attr) != null) {
            return this.symb.get(attr).get((int)this.data[attr][i]);
        }
        return Float.valueOf(this.data[attr][i]);
    }

    public Object getLabelValue(int i) {
        int lab = this.params.getLabelCol();
        if (lab >= 0) {
            if (this.isSymbolicAttribute(lab)) {
                return this.symb.get(lab).get((int)this.data[lab][i]);
            }
            return Float.toString(this.data[lab][i]);
        }
        return "" + i;
    }

    public Object[][] getAllDescription(int[] indices) {
        int size = indices.length;
        Object[][] res = new Object[size][this.nbatt + 1];
        int cptobj = 0;
        while (cptobj < size) {
            res[cptobj][0] = indices[cptobj];
            ++cptobj;
        }
        int cptcol = 0;
        while (cptcol < this.nbatt) {
            int cptobj2;
            if (this.symb.get(cptcol) == null) {
                cptobj2 = 0;
                while (cptobj2 < size) {
                    res[indices[cptobj2]][cptcol + 1] = new Float(this.data[cptcol][indices[cptobj2]]);
                    ++cptobj2;
                }
            } else {
                cptobj2 = 0;
                while (cptobj2 < size) {
                    res[indices[cptobj2]][cptcol + 1] = this.symb.get(cptcol).get((int)this.data[cptcol][indices[cptobj2]]);
                    ++cptobj2;
                }
            }
            ++cptcol;
        }
        return res;
    }

    public void afficheClasseDistrib() {
        int col = this.params.getClassCol();
        int nbcl = this.symb.get(col).size();
        int[] classes = new int[nbcl];
        int i = 0;
        while (i < nbcl) {
            classes[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.nbDescrObjects) {
            int n = (int)this.data[col][i];
            classes[n] = classes[n] + 1;
            ++i;
        }
        this.distrib[col] = null;
    }

    public int getClassSize(int nc) {
        int col = this.params.getClassCol();
        return this.getGroupCardByCol(col, nc);
    }

    public int getGroupCardinality(int role, int group) {
        return this.getGroupCardByCol(this.params.getRoleColumn(role), group);
    }

    private int getGroupCardByCol(int col, int group) {
        if (this.distrib[col] == null) {
            int nbcl = this.symb.get(col).size();
            this.distrib[col] = new int[nbcl];
            int i = 0;
            while (i < nbcl) {
                this.distrib[col][i] = 0;
                ++i;
            }
            i = 0;
            while (i < this.nbDescrObjects) {
                int[] nArray = this.distrib[col];
                int n = (int)this.data[col][i];
                nArray[n] = nArray[n] + 1;
                ++i;
            }
        }
        return this.distrib[col][group];
    }

    public int[] getIndicesByRole(int role) {
        int col = this.params.getRoleColumn(role);
        int[] classes = new int[this.nbDescrObjects];
        int i = 0;
        while (i < this.nbDescrObjects) {
            classes[i] = (int)this.data[col][i];
            ++i;
        }
        return classes;
    }

    public int getNbDescrObjects() {
        return this.nbDescrObjects;
    }

    public void setNbDescrObjects(int nbDescrObjects) {
        this.nbDescrObjects = nbDescrObjects;
    }

    public int getNbAtt() {
        return this.nbatt;
    }

    public float elementAt(int col, int line) {
        return this.data[col][line];
    }

    public String getSymbElementAt(int i) {
        int col = this.params.getClassCol();
        return (String)this.symb.get(col).get(i);
    }

    public int addParam(int att, String val) {
        int i = 0;
        List<Object> param = this.symb.get(att);
        while (i < param.size() && !val.equals(param.get(i))) {
            ++i;
        }
        if (i == param.size()) {
            param.add(val);
        }
        return i;
    }

    public int getNumParam(int att, String val) {
        int i = 0;
        List<Object> param = this.symb.get(att);
        while (i < param.size() && !val.equals(param.get(i))) {
            ++i;
        }
        if (i == param.size()) {
            return 0;
        }
        return i;
    }

    public void setParamValue(int obj, int att, float val) {
        this.data[att][obj] = val;
    }

    public void setParamValues(int[] objs, int att, int[] vals) {
        int i = 0;
        while (i < objs.length) {
            this.data[att][objs[i]] = vals[i];
            ++i;
        }
        this.setChanged();
        this.notifyObservers(new Changes(this.params.getColumnRole(att), objs, vals));
    }

    public void setParamValue(int obj, int att, String val) {
        float numval = this.symb.get(att) != null ? (float)this.addParam(att, val) : Float.parseFloat(val);
        this.data[att][obj] = numval;
    }

    public void completeColumn(int att) {
        int i = 0;
        while (i < this.nbDescrObjects) {
            if (this.data[att][i] == -1.0f) {
                this.setParamValue(i, att, "UNDEFINED");
            }
            ++i;
        }
    }

    public void addColumn(float[] values, String name) {
        this.addColumn(values, null, name);
    }

    public void addColumn(float[] values, List<Object> symbols, String name) {
        float[][] temp = new float[this.nbatt + 1][this.nbDescrObjects];
        if (this.data != null) {
            int i = 0;
            while (i < this.nbatt) {
                System.arraycopy(this.data[i], 0, temp[i], 0, this.nbDescrObjects);
                ++i;
            }
        }
        System.arraycopy(values, 0, temp[this.nbatt], 0, this.nbDescrObjects);
        this.data = temp;
        this.symb.add(symbols);
        String[] tempn = new String[this.nbatt + 1];
        if (this.compAttrNames != null) {
            System.arraycopy(this.compAttrNames, 0, tempn, 0, this.nbatt);
        }
        int rank = 0;
        int i = this.nbatt - 1;
        while (i >= 0) {
            if (tempn[i].startsWith(name)) {
                if (tempn[i].equals(name)) {
                    rank = 2;
                    break;
                }
                String remain = tempn[i].substring(name.length() + 1);
                if (remain.startsWith("(") && remain.endsWith(")")) {
                    remain = remain.substring(1, remain.length() - 1);
                    try {
                        rank = Integer.parseInt(remain) + 1;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            --i;
        }
        if (rank != 0) {
            name = String.valueOf(name) + " (" + rank + ")";
        }
        tempn[this.nbatt] = name;
        this.compAttrNames = tempn;
        this.tmpcols.add(0, this.nbatt);
        int[][] tempodistr = new int[this.nbatt + 1][];
        int i2 = 0;
        while (i2 < this.nbatt) {
            tempodistr[i2] = this.distrib[i2];
            ++i2;
        }
        tempodistr[this.nbatt] = null;
        this.distrib = tempodistr;
        ++this.nbatt;
        this.notifyObservers();
    }

    public void resetTmpColumns() {
        this.tmpcols.clear();
    }

    public void clean() {
        for (int numcol : this.tmpcols) {
            this.dropColumn(numcol);
        }
        this.resetTmpColumns();
        this.individualChange = false;
        this.notifyObservers();
        this.individualChange = true;
    }

    public int addColumn(String name) {
        float[] values = new float[this.nbDescrObjects];
        Arrays.fill(values, -1.0f);
        ArrayList symb = null;
        int suffix = name.lastIndexOf(".N");
        if (suffix != -1) {
            name = name.substring(0, suffix);
        } else {
            suffix = name.lastIndexOf(".S");
            if (suffix != -1) {
                name = name.substring(0, suffix);
            }
            symb = new ArrayList();
        }
        this.addColumn(values, symb, name);
        return this.nbatt - 1;
    }

    public void dropColumnStartWith(String nom) {
        int rank;
        do {
            rank = this.compAttrNames.length - 1;
            while (rank >= 0 && !this.compAttrNames[rank].startsWith(nom)) {
                --rank;
            }
            if (rank <= 0) continue;
            this.dropColumn(rank);
        } while (rank >= 0);
    }

    public void dropColumn(String nom) {
        int rank = this.compAttrNames.length - 1;
        while (rank >= 0 && !this.compAttrNames[rank].equals(nom)) {
            --rank;
        }
        if (rank == -1) {
            return;
        }
        this.dropColumn(rank);
    }

    private void dropColumn(int rank) {
        int unset = this.params.unsetColsSetAt(rank);
        int[][] tempodistr = new int[this.nbatt - 1][];
        int i = 0;
        while (i < rank) {
            tempodistr[i] = this.distrib[i];
            ++i;
        }
        i = rank;
        while (i < this.nbatt - 1) {
            tempodistr[i] = this.distrib[i + 1];
            ++i;
        }
        this.distrib = tempodistr;
        float[][] temp = new float[this.nbatt - 1][this.nbDescrObjects];
        String[] tempn = new String[this.nbatt - 1];
        int i2 = 0;
        while (i2 < rank) {
            System.arraycopy(this.data[i2], 0, temp[i2], 0, this.nbDescrObjects);
            ++i2;
        }
        i2 = rank;
        while (i2 < this.nbatt - 1) {
            System.arraycopy(this.data[i2 + 1], 0, temp[i2], 0, this.nbDescrObjects);
            ++i2;
        }
        if (rank > 0) {
            System.arraycopy(this.compAttrNames, 0, tempn, 0, rank);
        }
        if (rank < this.nbatt - 1) {
            System.arraycopy(this.compAttrNames, rank, tempn, rank + 1, this.nbatt - rank - 1);
        }
        this.data = temp;
        this.symb.remove(rank);
        this.compAttrNames = tempn;
        --this.nbatt;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void notifyObservers() {
        if (this.individualChange) {
            this.setChanged();
            super.notifyObservers();
        }
    }

    public static final class Changes {
        public int attr;
        public int[] objs;
        public int[] vals;

        public Changes(int a, int[] o, int[] v) {
            this.attr = a;
            this.objs = o;
            this.vals = v;
        }
    }
}

