/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.data;

import explorer.data.DataManager;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import lib3d4j.data.DescriptionData;
import lib3d4j.data.Source;

public abstract class SourceImpl
implements Source {
    protected URL url = null;
    protected int type = 1000;
    protected int nbObjects = 0;
    protected int[] realIndex;
    protected String id;
    protected Source parent = null;
    protected DescriptionData comp = DataManager.getSingleton().getCompAttr();

    public String toString() {
        return DataManager.getSingleton().getTypeValue(this.type);
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.toString()) + " (");
        if (this.parent != null) {
            sb.append("From " + this.parent.getName());
        } else if (this.url == null) {
            sb.append("From scratch");
        } else {
            String file = this.url.getFile();
            sb.append(file.substring(file.lastIndexOf(47) + 1));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setParent(Source s, boolean ri) {
        this.parent = s;
        if (ri) {
            this.realIndex = ((SourceImpl)this.parent).realIndex;
        }
    }

    @Override
    public Source getParent() {
        return this.parent;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getNbObjects() {
        return this.nbObjects;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(URL url) {
        this.url = url;
    }

    public static String check(Vector<String> vlist) {
        return null;
    }

    protected void initRealIndex() {
        this.realIndex = new int[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            this.realIndex[i] = i;
            ++i;
        }
    }

    @Override
    public int getRealIndex(int idx) {
        return this.realIndex[idx];
    }

    @Override
    public int getLocalIndex(int idx) {
        int rank = 0;
        while (rank < this.nbObjects && this.realIndex[rank] < idx) {
            ++rank;
        }
        if (rank < this.nbObjects && this.realIndex[rank] == idx) {
            return rank;
        }
        return -1;
    }

    @Override
    public abstract float[] distOrigine();

    @Override
    public abstract float distance(int var1, int var2);

    @Override
    public Source crop(List<Integer> crop) {
        int[] tab = new int[crop.size()];
        int i = 0;
        while (i < crop.size()) {
            tab[i] = crop.get(i);
            ++i;
        }
        return this.crop(tab);
    }

    protected int[] readCompAttrNames(StringTokenizer st) {
        int w = st.countTokens();
        int[] ranks = new int[w];
        if (w > 0) {
            int i = 0;
            while (st.hasMoreTokens()) {
                ranks[i] = this.comp.addColumn(st.nextToken());
                ++i;
            }
        }
        return ranks;
    }

    protected void readCompAttrs(int obj, StringTokenizer st, int[] rank) {
        st.countTokens();
        int i = 0;
        while (st.hasMoreTokens()) {
            this.comp.setParamValue(obj, rank[i], st.nextToken().trim());
            ++i;
        }
    }

    protected void completeCompAttrs(int[] rank) {
        if (rank != null) {
            int[] nArray = rank;
            int n = rank.length;
            int n2 = 0;
            while (n2 < n) {
                int r = nArray[n2];
                this.comp.completeColumn(r);
                ++n2;
            }
        }
    }

    protected int[] initCompAttrNames(int n) {
        int[] ranks = new int[n];
        if (n > 0) {
            int i = 0;
            while (i < n) {
                ranks[i] = this.comp.addColumn("Att" + (i + 1));
                ++i;
            }
        }
        return ranks;
    }

    protected static boolean isSeparator(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != '_' && s.charAt(i) != '\'' && s.charAt(i) != '\"' && s.charAt(i) != ' ' && s.charAt(i) != '*' && s.charAt(i) != ',' && s.charAt(i) != '\t' && s.charAt(i) != '/' && s.charAt(i) != '|' && s.charAt(i) != ':') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

