/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D;

import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import lib3d4j.data.Coordinates;
import lib3d4j.data.DatasetParams;
import lib3d4j.data.DescriptionData;
import lib3d4j.data.Options;
import lib3d4j.data.Source;
import lib3d4j.display3D.DisplayCallBack;
import lib3d4j.display3D.java3D.data.Parameters3D;
import lib3d4j.display3D.java3D.tools.LocalCoord;
import lib3d4j.w2d.Legendable;

public interface Display
extends Legendable,
DisplayCallBack {
    public static final int SPHERE = 3;
    public static final int BOX = 1;
    public static final int CYLINDER = 2;
    public static final int CONE = 0;
    public static final int CROIX = 4;
    public static final int HORIZONTAL = 5;
    public static final int VERTICAL = 6;
    public static final float DEFAULT_SIZE = 0.02f;

    public void setVisible(boolean var1);

    public void remove();

    public int getWidth();

    public int getHeight();

    public Image getScreenCapture();

    public Dimension2D getSize();

    public Point2D getLocationOnScreen();

    public void resetData(Coordinates var1, DescriptionData var2, boolean var3);

    public int addCone(float[] var1, float var2);

    public int addCone(float[] var1, float[] var2, float var3);

    public int addBox(float var1, float var2, float var3, float var4, float var5, float var6, int var7, boolean var8);

    public int addBox(float var1, float var2, float var3, float var4, float var5, float var6);

    public int addCube(float[] var1, float var2);

    public int addCube(float[] var1, float var2, int var3);

    public void setCubeColors(int var1);

    public int addPolyedron(int[][] var1, int var2);

    public int addCylinder(float[] var1, float var2);

    public int addEllipsoid(float[] var1, float[] var2, float[] var3);

    public int addSphere(float[] var1, float var2);

    public int addText(float[] var1, String var2);

    public int addLine(float[] var1, float[] var2);

    public int addTriangle(int var1, int var2, int var3);

    public void removeCubes();

    public void setLabel(int var1, String var2);

    public void setLabelsVisible(boolean var1);

    public boolean isLabelsVisible();

    public void switchLabel(int var1);

    public void setLabelVisible(int var1, boolean var2);

    public void switchLabels(boolean var1);

    public void removeObject(int var1);

    public void setBrightness(int var1, float var2);

    public void setSelected(int var1, boolean var2);

    public boolean isSelected(int var1);

    public void selectAll(boolean var1);

    public int countSelected();

    public int[] getSelectedObjects();

    public void showHidePicture(int var1);

    public void showHidePictureLocal(int var1);

    public void setObjectColor(int var1, Color var2);

    public void setObjectColor(int var1, int var2);

    public void setObjectColor(int var1, float var2);

    public void setObjectsColor(int[] var1, int[] var2);

    public void setObjectVisible(int var1, boolean var2);

    public void setAllObjectsVisible(boolean var1);

    public void setObjectSize(float var1);

    public float getObjectSize();

    public float getDefaultSize();

    public void setDefaultSize(float var1);

    public void setAspect(Parameters3D var1);

    public Parameters3D getAspect();

    public void setColorTable(int var1);

    public void setColorTable(Color[] var1);

    public void setGradientColorTable(float var1, float var2);

    public void setLabelSize(float var1);

    public int getNbObjects();

    public void setDefaultColor(Color var1);

    public void removePictures();

    public float[][] getPoints();

    public void centerObject(int var1);

    public boolean isInGroup(int var1, int var2);

    public int[] getGroupIndices();

    public void resetData(float[][] var1, Source var2, DatasetParams var3, boolean var4);

    public Options getOptions();

    public void setOptions(Options var1);

    public void translateRelativeView(float var1, float var2, float var3);

    public void translateViewHome();

    public void setRelativeAvatar(float var1, float var2, float var3);

    public void rotateRelativeView(float var1, float var2, float var3);

    public void createAvatar();

    public LocalCoord getLocalCoord();

    public void setXYWH(int var1, int var2, int var3, int var4);
}

