/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.java3D.tools;

public class LocalCoord {
    public static float minscaling = 0.0f;
    public static final float UNIT_LENGTH = 500.0f;
    private float xMin;
    private float yMin;
    private float zMin;
    private float xScale;
    private float yScale;
    private float zScale;
    private float mx;
    private float my;
    private float mz;
    private boolean normalize = false;
    private boolean centre = false;
    private boolean fake = false;

    public LocalCoord() {
        this.fake = true;
    }

    public LocalCoord(float[][] tab3D, boolean normalize, boolean centre) {
        this.setLocCoord(tab3D, normalize, centre);
    }

    public float[][] getLocCoord(float[][] tab3D) {
        int nbPt = tab3D.length;
        float[][] lc = new float[nbPt][];
        int i = 0;
        while (i < nbPt) {
            lc[i] = this.getLocCoord(tab3D[i]);
            ++i;
        }
        return lc;
    }

    public float[] getCoordGlobal(float[] localCoord) {
        float[] coordGlobal = new float[3];
        int i = 0;
        while (i < 3) {
            coordGlobal[i] = localCoord[i];
            ++i;
        }
        if (!this.fake) {
            coordGlobal[0] = coordGlobal[0] / 500.0f;
            coordGlobal[1] = coordGlobal[1] / 500.0f;
            coordGlobal[2] = coordGlobal[2] / 500.0f;
            if (!this.normalize) {
                coordGlobal[0] = coordGlobal[0] / (this.xScale / this.mx);
                coordGlobal[1] = coordGlobal[1] / (this.yScale / this.my);
                coordGlobal[2] = coordGlobal[2] / (this.zScale / this.mz);
            }
            if (this.centre) {
                coordGlobal[0] = coordGlobal[0] * (this.xScale - 0.5f) + this.xMin;
                coordGlobal[1] = coordGlobal[1] * (this.yScale - 0.5f) + this.yMin;
                coordGlobal[2] = coordGlobal[2] * (this.zScale - 0.5f) + this.zMin;
            } else {
                coordGlobal[0] = coordGlobal[0] * this.xScale;
                coordGlobal[1] = coordGlobal[1] * this.yScale;
                coordGlobal[2] = coordGlobal[2] * this.zScale;
            }
        }
        return coordGlobal;
    }

    public float[] getLocCoord(float[] pt) {
        float[] lc = new float[3];
        if (this.fake) {
            int i = 0;
            while (i < 3) {
                lc[i] = pt[i];
                ++i;
            }
        } else {
            if (this.centre) {
                lc[0] = (pt[0] - this.xMin) / this.xScale - 0.5f;
                lc[1] = (pt[1] - this.yMin) / this.yScale - 0.5f;
                lc[2] = (pt[2] - this.zMin) / this.zScale - 0.5f;
            } else {
                lc[0] = pt[0] / this.xScale;
                lc[1] = pt[1] / this.yScale;
                lc[2] = pt[2] / this.zScale;
            }
            if (!this.normalize) {
                lc[0] = lc[0] * (this.xScale / this.mx);
                lc[1] = lc[1] * (this.yScale / this.my);
                lc[2] = lc[2] * (this.zScale / this.mz);
            }
            lc[0] = lc[0] * 500.0f;
            lc[1] = lc[1] * 500.0f;
            lc[2] = lc[2] * 500.0f;
        }
        return lc;
    }

    private float getMin(float[][] tab, int axe) {
        int nbelem = tab.length;
        float min = tab[0][axe];
        int i = 1;
        while (i < nbelem) {
            if (tab[i][axe] < min) {
                min = tab[i][axe];
            }
            ++i;
        }
        return min;
    }

    private float getMax(float[][] tab, int axe) {
        int nbelem = tab.length;
        float max = tab[0][axe];
        int i = 1;
        while (i < nbelem) {
            if (tab[i][axe] > max) {
                max = tab[i][axe];
            }
            ++i;
        }
        return max;
    }

    private void setLocCoord(float[][] tab3D, boolean normalize, boolean centre) {
        this.normalize = normalize;
        this.centre = centre;
        this.xMin = this.getMin(tab3D, 0);
        float xMax = this.getMax(tab3D, 0);
        this.yMin = this.getMin(tab3D, 1);
        float yMax = this.getMax(tab3D, 1);
        this.zMin = this.getMin(tab3D, 2);
        float zMax = this.getMax(tab3D, 2);
        if (!centre) {
            if (xMax < 0.0f) {
                xMax = 0.0f;
            }
            if (yMax < 0.0f) {
                yMax = 0.0f;
            }
            if (zMax < 0.0f) {
                zMax = 0.0f;
            }
            if (this.xMin > 0.0f) {
                this.xMin = 0.0f;
            }
            if (this.yMin > 0.0f) {
                this.yMin = 0.0f;
            }
            if (this.zMin > 0.0f) {
                this.zMin = 0.0f;
            }
        }
        this.xScale = xMax - this.xMin;
        if (this.xScale <= minscaling) {
            this.xScale = 1.0f;
        }
        this.yScale = yMax - this.yMin;
        if (this.yScale <= minscaling) {
            this.yScale = 1.0f;
        }
        this.zScale = zMax - this.zMin;
        if (this.zScale <= minscaling) {
            this.zScale = 1.0f;
        }
        if (normalize) {
            this.mx = this.xScale;
            this.my = this.yScale;
            this.mz = this.zScale;
        } else {
            this.mx = this.xScale;
            if (this.yScale > this.mx) {
                this.mx = this.yScale;
            }
            if (this.zScale > this.mx) {
                this.mx = this.zScale;
            }
            this.my = this.mz = this.mx;
        }
    }
}

