/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.javafx;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point3D;
import javafx.scene.Camera;
import javafx.scene.Cursor;
import javafx.scene.DepthTest;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.Sphere;
import javafx.scene.text.Text;
import lib3d4j.compute.tools.OutilsAlgebre;
import lib3d4j.display3D.DisplayCallBack;
import lib3d4j.display3D.javafx.XForm;
import lib3d4j.display3D.javafx.objects.AxesJFX;
import lib3d4j.display3D.javafx.objects.Cone;
import lib3d4j.display3D.javafx.objects.Ellipsoid;
import lib3d4j.display3D.javafx.objects.Polyedron;
import lib3d4j.display3D.javafx.objects.RichPrimitiveFactoryJFX;
import lib3d4j.display3D.javafx.objects.Target;
import lib3d4j.display3D.javafx.objects.Triangle;

public class SceneJFX {
    private static final double CAMERA_INITIAL_DISTANCE = -1000.0;
    private static final double CAMERA_INITIAL_X_ANGLE = 0.0;
    private static final double CAMERA_INITIAL_Y_ANGLE = 0.0;
    private static final double CAMERA_NEAR_CLIP = 0.1;
    private static final double CAMERA_FAR_CLIP = 10000.0;
    private Scene scene = null;
    private Group root = new Group();
    private XForm world = new XForm();
    private XForm inScene = new XForm();
    private XForm outOfScene = new XForm();
    final PerspectiveCamera camera = new PerspectiveCamera(true);
    final XForm cameraXform = new XForm();
    final XForm cameraXform2 = new XForm();
    final XForm cameraXform3 = new XForm();
    private int nbFacets = 30;
    public static RichPrimitiveFactoryJFX rpfApp;
    public static final float DEFAULT_SIZE = 10.0f;
    private SubScene subScene;
    private Rectangle selectRectangle = null;

    public SceneJFX(DisplayCallBack p, boolean stereo) {
        this.root.setDepthTest(DepthTest.ENABLE);
        rpfApp = RichPrimitiveFactoryJFX.getFactory();
        this.buildScene();
        this.root.getChildren().add((Object)this.world);
        BorderPane rootLayout = new BorderPane();
        this.subScene = new SubScene((Parent)this.root, 1024.0, 768.0, true, SceneAntialiasing.BALANCED);
        rootLayout.setCenter((Node)this.subScene);
        this.scene = new Scene((Parent)rootLayout);
        this.scene.setFill((Paint)Color.GREY);
        this.subScene.setFill((Paint)Color.GREY);
        this.handleMouse(this.scene, (Node)this.world);
        this.buildCamera();
        this.subScene.setCamera((Camera)this.camera);
    }

    public XForm getWorld() {
        return this.world;
    }

    public void buildScene() {
        this.world.getChildren().add((Object)this.inScene);
    }

    public XForm addTarget(XForm trans, Color color, double radius) {
        Target target = new Target(color, radius, radius);
        trans.getChildren().add((Object)target);
        return this.trace(trans);
    }

    public XForm addSphere(XForm trans, float scale, Color col) {
        return this.addSphere(trans, scale, (Material)rpfApp.getAppearance(col), false, true);
    }

    public XForm addSphere(XForm trans, float scale, Material app, boolean resizable, boolean forLabeling) {
        Sphere sph = new Sphere(1.0, this.nbFacets);
        sph.setMaterial(app);
        return this.addPrimitive((Shape3D)sph, trans, scale, resizable, forLabeling);
    }

    public void setShine(int nbobj) {
        this.nbFacets = nbobj < 500 ? 50 : (nbobj < 1000 ? 30 : (nbobj < 5000 ? 20 : 10));
    }

    public XForm addPrimitive(Shape3D p, XForm trans, float scale, boolean resizable, boolean forLabeling) {
        p.setScaleX((double)scale);
        p.setScaleY((double)scale);
        p.setScaleZ((double)scale);
        trans.getChildren().add((Object)p);
        return this.trace(trans);
    }

    public XForm addCylinder(XForm trans, float scale, Color col, boolean forLabeling) {
        PhongMaterial mat = rpfApp.getAppearance(col);
        return this.addCylinder(trans, scale, (Material)mat, true, forLabeling);
    }

    public XForm addCylinder(XForm trans, float scale, Material mat, boolean resizable, boolean forLabeling) {
        Cylinder cyl = new Cylinder(1.0, 2.0);
        cyl.setMaterial(mat);
        return this.addPrimitive((Shape3D)cyl, trans, scale, resizable, forLabeling);
    }

    public XForm addCylinder(float[] centre, float scale) {
        XForm trans = new XForm();
        trans.setTranslate(centre[0], -centre[1], -centre[2]);
        return this.addCylinder(trans, scale, rpfApp.getDefaultColor(), false);
    }

    public XForm addImage(XForm trans, Image img) {
        ImageView iv = new ImageView(img);
        iv.setFitHeight(100.0);
        iv.setPreserveRatio(true);
        iv.setSmooth(true);
        iv.setCache(true);
        XForm rotation = new XForm();
        rotation.getChildren().add((Object)iv);
        trans.getChildren().add((Object)rotation);
        return this.trace(trans);
    }

    public XForm addVertex(float[] from, float[] to, Material app) {
        double len = OutilsAlgebre.distance(from, to);
        Box vertex = new Box(1.0, len, 1.0);
        vertex.setMaterial(app);
        XForm transX = new XForm();
        transX.setTranslateY(-len / 2.0);
        XForm rot = new XForm();
        float[] angle = OutilsAlgebre.vectorToAngle(new float[]{to[0] - from[0], to[1] - from[1], to[2] - from[2]}, 0);
        rot.setRotateX(angle[0]);
        rot.setRotateY(-angle[1]);
        rot.setRotateZ(-angle[2]);
        XForm trans = new XForm();
        trans.setTranslate(from[0], -from[1], -from[2]);
        transX.getChildren().add((Object)vertex);
        rot.getChildren().add((Object)transX);
        trans.getChildren().add((Object)rot);
        return this.trace(trans);
    }

    public XForm addTriangle(float[] v1, float[] v2, float[] v3, Material mat) {
        Triangle triangle = new Triangle(v1, v2, v3);
        triangle.setMaterial(mat);
        XForm xfTriangle = new XForm();
        xfTriangle.getChildren().add((Object)triangle);
        return this.trace(xfTriangle);
    }

    public XForm addPolyedron(float[][][] tab, Material mat) {
        Polyedron poly = new Polyedron(tab);
        poly.setMaterial(mat);
        XForm xfPoly = new XForm();
        xfPoly.getChildren().add((Object)poly);
        return this.trace(xfPoly);
    }

    public void addMove(XForm objSpin) {
    }

    public XForm addVertex(float[] from, float[] to) {
        return this.addVertex(from, to, (Material)rpfApp.getDefaultAppearance(false));
    }

    public XForm traceFree(XForm sh) {
        this.addMove(sh);
        return sh;
    }

    public XForm trace(XForm sh) {
        return this.trace(sh, true);
    }

    public XForm trace(XForm sh, boolean in) {
        this.addMove(sh);
        if (in) {
            this.inScene.getChildren().add((Object)sh);
        } else {
            this.outOfScene.getChildren().add((Object)sh);
        }
        return sh;
    }

    public XForm addText(float[] depart, String texte) {
        return this.addText(depart, texte, (Material)rpfApp.getDefaultAppearance(false), 1.0f);
    }

    public XForm addText(float[] depart, String texte, Material apText, float scal) {
        Text tX = new Text(texte);
        XForm labelX = new XForm();
        labelX.setTranslate(depart[0] + 5.0f, -depart[1], -depart[2]);
        labelX.getChildren().add((Object)tX);
        return this.trace(labelX);
    }

    public XForm createText(String texte, float offset) {
        Text tX = new Text(texte);
        XForm labelX = new XForm();
        labelX.setTranslate(offset, 0.0, 0.0);
        labelX.getChildren().add((Object)tX);
        return this.traceFree(labelX);
    }

    public XForm addCone(XForm trans, float scale, Material app, boolean resizable, boolean forLabeling) {
        Cone cone = new Cone(1.0f, 2.0f, 20);
        cone.setMaterial(app);
        return this.addPrimitive((Shape3D)cone, trans, scale, resizable, forLabeling);
    }

    public XForm addCone(XForm trans, float scale, Color col) {
        return this.addCone(trans, scale, (Material)rpfApp.getAppearance(col));
    }

    public XForm addCone(XForm trans, float scale, Material app) {
        return this.addCone(trans, scale, app, true, true);
    }

    public void removeObject(Group objet) {
        if (objet == null) {
            return;
        }
        this.inScene.getChildren().remove((Object)objet);
    }

    public XForm addEllipse(float[] centre, float[] axislongueur, float[] axislargeur, float[] axisprofondeur, Material mat) {
        float longueur = OutilsAlgebre.length(axislongueur);
        float largeur = OutilsAlgebre.length(axislargeur);
        float profondeur = OutilsAlgebre.length(axisprofondeur);
        return this.addEllipse(centre, new float[][]{axislongueur, axislargeur}, longueur, largeur, profondeur, mat);
    }

    public XForm addEllipse(float[] centre, float[][] axes, float long1, float long2, float long3, Material mat) {
        XForm translation = new XForm();
        XForm rotationFirst = new XForm();
        XForm rotationSecond = new XForm();
        translation.setTranslate(centre[0], -centre[1], -centre[2]);
        int i = 0;
        while (i < 2) {
            axes[i][1] = -axes[i][1];
            axes[i][2] = -axes[i][2];
            ++i;
        }
        float[] rot = axes[0];
        float[] ref = new float[]{0.0f, 1.0f, 0.0f};
        if (rot[1] < 0.0f) {
            int i2 = 0;
            while (i2 < 3) {
                rot[i2] = -rot[i2];
                ++i2;
            }
        }
        float cos = (float)((double)(rot[0] * ref[0] + rot[1] * ref[1] + rot[2] * ref[2]) / Math.sqrt(rot[0] * rot[0] + rot[1] * rot[1] + rot[2] * rot[2]));
        float angle = (float)(-Math.acos(cos) * 180.0 / Math.PI);
        float x = rot[1] * ref[2] - rot[2] * ref[1];
        float y = rot[2] * ref[0] - rot[0] * ref[2];
        float z = rot[0] * ref[1] - rot[1] * ref[0];
        Point3D raFirst = new Point3D((double)x, (double)y, (double)z);
        rotationFirst.setRotationAxis(raFirst);
        rotationFirst.setRotate(angle);
        rot = axes[1];
        angle = 0.0f;
        int adj = 0;
        int opp = 2;
        if (axes[0][1] == 0.0f) {
            opp = 1;
        }
        angle = rot[adj] == 0.0f ? 90.0f : (rot[opp] == 0.0f ? 0.0f : (float)(-Math.atan(rot[opp] / rot[adj]) * 180.0 / Math.PI));
        rotationSecond.setRotateY(angle);
        Ellipsoid e = new Ellipsoid(long1, long2, long3, 30);
        e.setMaterial(mat);
        rotationSecond.getChildren().add((Object)e);
        rotationFirst.getChildren().add((Object)rotationSecond);
        translation.getChildren().add((Object)rotationFirst);
        return this.trace(translation);
    }

    public XForm setAxis(int numeroAxes, int style) {
        XForm bg = AxesJFX.createAxes(numeroAxes, style);
        if (bg == null) {
            return bg;
        }
        this.inScene.getChildren().addAll((Object[])new Node[]{bg});
        return bg;
    }

    public void setColor(Shape3D p, Color c) {
        PhongMaterial a = rpfApp.getAppearance(c);
        p.setMaterial((Material)a);
    }

    public XForm addBox(XForm trans, float scale, Color color) {
        return this.addBox(trans, scale, scale, scale, color, true);
    }

    public XForm addBox(XForm trans, float scale, Material app) {
        return this.addBox(trans, scale, app, true, true);
    }

    public XForm addBox(XForm trans, float scale, Material app, boolean resizable, boolean forLabeling) {
        return this.addBox(trans, 1.0f, 1.0f, 1.0f, scale, app, resizable, forLabeling);
    }

    public XForm addBox(XForm trans, float x, float y, float z, Color col, boolean forLabeling) {
        return this.addBox(trans, x, y, z, 1.0f, (Material)rpfApp.getAppearance(col), true, forLabeling);
    }

    public XForm addBox(XForm trans, float x, float y, float z, float scale, Material app, boolean resizable, boolean forLabeling) {
        Box b = new Box((double)(2.0f * x), (double)(2.0f * y), (double)(2.0f * z));
        b.setMaterial(app);
        return this.addPrimitive((Shape3D)b, trans, scale, resizable, forLabeling);
    }

    public void setFlatSelOn(boolean on) {
        if (on) {
            this.scene.setCursor(Cursor.NW_RESIZE);
        } else {
            this.scene.setCursor(Cursor.DEFAULT);
            if (this.selectRectangle != null) {
                ((BorderPane)this.scene.getRoot()).getChildren().remove((Object)this.selectRectangle);
                this.selectRectangle = null;
            }
        }
    }

    public void drawSelectRectangle(int x0, int y0, int x1, int y1) {
        int x = Math.min(x0, x1);
        int y = Math.min(y0, y1);
        int width = Math.abs(x0 - x1);
        int height = Math.abs(y0 - y1);
        if (x0 < x1) {
            if (y0 < y1) {
                this.scene.setCursor(Cursor.SE_RESIZE);
            } else {
                this.scene.setCursor(Cursor.NE_RESIZE);
            }
        } else if (y0 < y1) {
            this.scene.setCursor(Cursor.SW_RESIZE);
        } else {
            this.scene.setCursor(Cursor.NW_RESIZE);
        }
        if (this.selectRectangle == null) {
            this.selectRectangle = new Rectangle((double)x, (double)y, (double)width, (double)height);
            this.selectRectangle.setStroke((Paint)Color.YELLOW);
            this.selectRectangle.setFill((Paint)Color.gray((double)0.1f, (double)0.1f));
            ((BorderPane)this.scene.getRoot()).getChildren().add((Object)this.selectRectangle);
        } else {
            this.selectRectangle.setX((double)x);
            this.selectRectangle.setY((double)y);
            this.selectRectangle.setWidth((double)width);
            this.selectRectangle.setHeight((double)height);
        }
    }

    private void buildCamera() {
        this.root.getChildren().add((Object)this.cameraXform);
        this.cameraXform.getChildren().add((Object)this.cameraXform2);
        this.cameraXform2.getChildren().add((Object)this.cameraXform3);
        this.cameraXform3.getChildren().add((Object)this.camera);
        this.camera.setNearClip(0.1);
        this.camera.setFarClip(10000.0);
        this.camera.setTranslateZ(-1000.0);
        this.cameraXform.ry.setAngle(0.0);
        this.cameraXform.rx.setAngle(0.0);
    }

    public void rotate(double xAngle, double yAngle) {
        yAngle = this.cameraXform.ry.getAngle() + yAngle;
        xAngle = this.cameraXform.rx.getAngle() + xAngle;
        this.cameraXform.ry.setAngle(yAngle);
        this.cameraXform.rx.setAngle(xAngle);
        counterRotateCentral.rotation(xAngle, yAngle);
    }

    public void zoom(double zTrans) {
        double newZ = this.camera.getTranslateZ() + zTrans;
        this.camera.setTranslateZ(newZ);
    }

    public void translate(double xTrans, double yTrans) {
        this.cameraXform2.t.setX(this.cameraXform2.t.getX() + xTrans);
        this.cameraXform2.t.setY(this.cameraXform2.t.getY() + yTrans);
    }

    private void handleMouse(Scene scene, Node root) {
    }

    public void resetView() {
        this.cameraXform2.t.setX(0.0);
        this.cameraXform2.t.setY(0.0);
        this.camera.setTranslateZ(-1000.0);
        this.cameraXform.ry.setAngle(0.0);
        this.cameraXform.rx.setAngle(0.0);
    }

    public XForm getInScene() {
        return this.inScene;
    }

    public void setBackground(Color col) {
        this.subScene.setFill((Paint)col);
    }

    public Scene getScene() {
        return this.scene;
    }

    public void resize(double width, double height) {
        this.subScene.setWidth(width);
        this.subScene.setHeight(height);
    }

    public static class counterRotateCentral {
        private static List<XForm> crForms = new ArrayList<XForm>();

        public static void addForm(XForm xf) {
            crForms.add(xf);
        }

        public static void removeForm(XForm xf) {
            crForms.remove((Object)xf);
        }

        public static void rotation(double x, double y) {
            for (XForm xf : crForms) {
                XForm xfrot = (XForm)((Object)xf.getChildren().get(0));
                xfrot.setRotateX(x);
                xfrot.setRotateY(y);
            }
        }
    }
}

