/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.javafx;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.stage.Window;
import lib3d4j.display3D.Display;
import lib3d4j.display3D.javafx.DisplayJFX;
import lib3d4j.display3D.javafx.GeneralPopUpMenu;
import lib3d4j.display3D.javafx.SceneJFX;

public class SceneJFXController {
    private static final double CONTROL_MULTIPLIER = 0.1;
    private static final double SHIFT_MULTIPLIER = 10.0;
    private static final double MOUSE_SPEED = 0.5;
    private static final double ROTATION_SPEED = 2.0;
    private static final double TRACK_SPEED = 0.3;
    private double mousePosX;
    private double mousePosY;
    private double mouseOldX;
    private double mouseOldY;
    private double mouseDeltaX;
    private double mouseDeltaY;
    private SceneJFX scene;
    private Display display;

    public SceneJFXController(Display disp, SceneJFX sjfx) {
        this.display = disp;
        this.scene = sjfx;
        this.scene.getScene().setOnMousePressed(event -> {
            this.mousePosX = event.getSceneX();
            this.mousePosY = event.getSceneY();
            this.mouseOldX = event.getSceneX();
            this.mouseOldY = event.getSceneY();
        });
        this.scene.getScene().setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                SceneJFXController.this.mouseOldX = SceneJFXController.this.mousePosX;
                SceneJFXController.this.mouseOldY = SceneJFXController.this.mousePosY;
                SceneJFXController.this.mousePosX = me.getSceneX();
                SceneJFXController.this.mousePosY = me.getSceneY();
                SceneJFXController.this.mouseDeltaX = SceneJFXController.this.mousePosX - SceneJFXController.this.mouseOldX;
                SceneJFXController.this.mouseDeltaY = SceneJFXController.this.mousePosY - SceneJFXController.this.mouseOldY;
                double modifier = 1.0;
                if (me.isControlDown()) {
                    modifier = 0.1;
                }
                if (me.isShiftDown()) {
                    modifier = 10.0;
                }
                if (me.isPrimaryButtonDown()) {
                    double yAngle = SceneJFXController.this.mouseDeltaX * 0.5 * modifier * 2.0;
                    double xAngle = -SceneJFXController.this.mouseDeltaY * 0.5 * modifier * 2.0;
                    SceneJFXController.this.scene.rotate(xAngle, yAngle);
                } else if (me.isMiddleButtonDown()) {
                    SceneJFXController.this.scene.zoom(-SceneJFXController.this.mouseDeltaX * 0.5 * modifier);
                } else if (me.isSecondaryButtonDown()) {
                    double xTrans = -SceneJFXController.this.mouseDeltaX * 0.5 * modifier * 0.3;
                    double yTrans = -SceneJFXController.this.mouseDeltaY * 0.5 * modifier * 0.3;
                    SceneJFXController.this.scene.translate(xTrans, yTrans);
                }
            }
        });
        this.scene.getScene().setOnMouseClicked((EventHandler)new StandardClicHandler());
        this.scene.getScene().setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                switch (event.getCode()) {
                    case Z: {
                        SceneJFXController.this.scene.resetView();
                    }
                }
            }
        });
    }

    public void switchToRectangle() {
        RectangleHandler rh = new RectangleHandler();
        this.scene.getScene().setOnMouseClicked((EventHandler)rh);
        this.scene.getScene().setOnMouseMoved((EventHandler)rh);
    }

    public void switchToStandard() {
        this.scene.getScene().setOnMouseClicked((EventHandler)new StandardClicHandler());
        this.scene.getScene().setOnMouseMoved(null);
    }

    final class RectangleHandler
    implements EventHandler<MouseEvent> {
        boolean first = true;
        int firstX = 0;
        int firstY = 0;
        int lastX = 0;
        int lastY = 0;

        RectangleHandler() {
        }

        public void handle(MouseEvent event) {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                if (this.first) {
                    this.firstX = (int)event.getSceneX();
                    this.firstY = (int)event.getSceneY();
                } else {
                    SceneJFXController.this.display.selectZone(this.firstX, this.firstY, this.lastX, this.lastY, true);
                }
                this.first = !this.first;
            } else if (event.getEventType().equals(MouseEvent.MOUSE_MOVED) && !this.first) {
                this.lastX = (int)event.getSceneX();
                this.lastY = (int)event.getSceneY();
                SceneJFXController.this.display.selectZone(this.firstX, this.firstY, this.lastX, this.lastY, false);
            }
        }
    }

    final class StandardClicHandler
    implements EventHandler<MouseEvent> {
        StandardClicHandler() {
        }

        public void handle(MouseEvent event) {
            if (!event.isStillSincePress()) {
                return;
            }
            int idx = -1;
            Node n = null;
            PickResult res = event.getPickResult();
            if (res.getIntersectedNode() instanceof Node) {
                n = res.getIntersectedNode();
                idx = ((DisplayJFX)SceneJFXController.this.display).indexPrimArray(n);
            }
            if (event.getButton() == MouseButton.PRIMARY) {
                if (idx != -1) {
                    if (event.isShiftDown()) {
                        SceneJFXController.this.display.setSelected(idx, !SceneJFXController.this.display.isSelected(idx));
                    } else {
                        SceneJFXController.this.display.clicLeft(n);
                    }
                }
            } else if (event.getButton() == MouseButton.SECONDARY) {
                GeneralPopUpMenu popup = new GeneralPopUpMenu(SceneJFXController.this.display, idx);
                popup.show((Window)((DisplayJFX)SceneJFXController.this.display).getStage(), event.getScreenX(), event.getScreenY());
            }
        }
    }
}

