/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.javafx.objects;

import java.io.Serializable;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;

public class Ellipsoid
extends MeshView
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Point2D[] profile;
    protected int divisions;
    protected float profondeur;
    private float longueur;
    private float largeur;

    public Ellipsoid(double a, double b, double c, int nbpt) {
        this.longueur = (float)a;
        this.largeur = (float)b;
        this.divisions = nbpt;
        this.profondeur = (float)c;
        this.tracer();
    }

    protected void tracer() {
        this.createCoords();
        PhongMaterial mat = new PhongMaterial();
        mat.setDiffuseColor(Color.BLACK);
        mat.setSpecularColor(Color.WHITE);
        this.setMaterial((Material)mat);
    }

    protected void createCoords() {
        this.profile = new Point2D[this.divisions];
        double angle = 0.0;
        double step = Math.PI / (double)(this.divisions - 1);
        int i = 0;
        while (i < this.divisions - 1) {
            this.profile[i] = new Point2D((double)((float)((double)this.largeur * Math.sin(angle))), (double)((float)((double)this.longueur * Math.cos(angle))));
            angle += step;
            ++i;
        }
        this.profile[this.divisions - 1] = new Point2D(0.0, (double)((float)((double)this.longueur * Math.cos(angle))));
        float[] pointsZ = new float[this.divisions];
        angle = 0.0;
        step = Math.PI / (double)(this.divisions - 1);
        int i2 = 0;
        while (i2 < this.divisions) {
            pointsZ[i2] = (float)((double)this.profondeur * Math.sin(angle));
            angle += step;
            ++i2;
        }
        pointsZ[this.divisions - 1] = pointsZ[0];
        int nbp = this.divisions;
        float[] coords = new float[nbp * this.divisions * 3];
        int i3 = 0;
        while (i3 < this.divisions) {
            int j = 0;
            while (j < nbp) {
                angle = Math.PI * 2 * (double)i3 / (double)this.divisions;
                coords[i3 * nbp * 3 + 3 * j] = (float)(this.profile[j].getX() * Math.cos(angle));
                coords[i3 * nbp * 3 + 3 * j + 1] = (float)this.profile[j].getY();
                coords[i3 * nbp * 3 + 3 * j + 2] = (float)((double)pointsZ[j] * Math.sin(angle));
                ++j;
            }
            ++i3;
        }
        float[] texCoords = new float[nbp * (this.divisions + 1) * 2];
        int i4 = 0;
        while (i4 <= this.divisions) {
            int j = 0;
            while (j < nbp) {
                texCoords[i4 * nbp * 2 + 2 * j] = (float)i4 / (float)this.divisions;
                texCoords[i4 * nbp * 2 + 2 * j + 1] = (float)j / (float)(nbp - 1);
                ++j;
            }
            ++i4;
        }
        int[] faces = new int[(nbp - 1) * this.divisions * 12];
        int nbf = 0;
        int i5 = 0;
        while (i5 < this.divisions) {
            int left = i5 * nbp;
            int pRight = (i5 + 1) % this.divisions * nbp;
            int tRight = (i5 + 1) * nbp;
            int j = 0;
            while (j < nbp - 1) {
                int top = j;
                int bottom = j + 1;
                faces[nbf++] = left + top;
                faces[nbf++] = left + top;
                faces[nbf++] = left + bottom;
                faces[nbf++] = left + bottom;
                faces[nbf++] = pRight + bottom;
                faces[nbf++] = tRight + bottom;
                faces[nbf++] = left + top;
                faces[nbf++] = left + top;
                faces[nbf++] = pRight + bottom;
                faces[nbf++] = tRight + bottom;
                faces[nbf++] = pRight + top;
                faces[nbf++] = tRight + top;
                ++j;
            }
            ++i5;
        }
        TriangleMesh tm = new TriangleMesh();
        tm.getPoints().addAll(coords);
        tm.getTexCoords().addAll(texCoords);
        tm.getFaces().addAll(faces);
        this.setMesh((Mesh)tm);
    }
}

