/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.javafx.objects;

import java.io.File;
import java.util.Arrays;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;

public class RichPrimitiveFactoryJFX {
    static final int DEFAULT_COLORS_NUMBER = 6;
    public static final int MAX_COLORS_NUMBER = 200;
    public static final int MAX_SHAPES_NUMBER = 4;
    public static Color DEFAULT_MIN_COLOR = Color.GREEN;
    public static Color DEFAULT_MAX_COLOR = Color.RED;
    public static final double TEXT_OFFSET = 5.0;
    private PhongMaterial cropMaterial;
    private PhongMaterial planeMaterial;
    private PhongMaterial[] tabMat = null;
    private PhongMaterial[] selectTabMat = null;
    private PhongMaterial[] translucentTabMat = null;
    private Color defaultColor = null;
    private Color[] tabColor = null;
    private int nbColor;
    private float minValue = 0.0f;
    private float maxValue = 1.0f;
    private Color minColor = DEFAULT_MIN_COLOR;
    private Color maxColor = DEFAULT_MAX_COLOR;
    private float stepR;
    private float stepG;
    private float stepB;
    private String textureDir = "textures";
    private Image[] timg = null;
    private int[] tidx = null;
    private boolean texturesOn;
    private static RichPrimitiveFactoryJFX singleton = null;

    public static synchronized RichPrimitiveFactoryJFX getFactory() {
        if (singleton == null) {
            singleton = new RichPrimitiveFactoryJFX();
        }
        return singleton;
    }

    private RichPrimitiveFactoryJFX() {
        this.init(-1);
    }

    private void init(int nbc) {
        this.cropMaterial = new PhongMaterial(Color.gray((double)0.5, (double)0.2f));
        Color planeColor = Color.color((double)Color.YELLOW.getRed(), (double)Color.YELLOW.getGreen(), (double)Color.YELLOW.getBlue(), (double)0.2f);
        this.planeMaterial = new PhongMaterial(planeColor);
        if (nbc != -1) {
            this.setAppearances(nbc);
        } else {
            this.setAppearances(6);
        }
        this.setDefaultColor(DEFAULT_MIN_COLOR);
        this.initSteps();
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color c) {
        this.defaultColor = c;
    }

    public void setTexturesOn(boolean b) {
        if (b) {
            if (this.timg == null) {
                this.loadTextures();
            }
            if (this.nbColor != 0) {
                this.setTextures();
            }
        } else {
            int i = 0;
            while (i < this.tabMat.length) {
                this.tabMat[i].setDiffuseMap(null);
                this.tabMat[i].setDiffuseColor(this.tabColor[i]);
                this.selectTabMat[i].setDiffuseMap(null);
                this.selectTabMat[i].setDiffuseColor(this.tabColor[i]);
                this.translucentTabMat[i].setDiffuseMap(null);
                this.translucentTabMat[i].setDiffuseColor(RichPrimitiveFactoryJFX.translucentColor(this.tabColor[i]));
                ++i;
            }
        }
        this.texturesOn = b;
    }

    private void setTextures() {
        if (this.timg.length >= this.nbColor) {
            int i = 0;
            while (i < this.nbColor) {
                this.tabMat[i].setDiffuseMap(this.timg[i]);
                this.tabMat[i].setDiffuseColor(Color.WHITE);
                this.selectTabMat[i].setDiffuseMap(this.timg[i]);
                this.selectTabMat[i].setDiffuseColor(Color.WHITE);
                this.translucentTabMat[i].setDiffuseMap(this.timg[i]);
                this.translucentTabMat[i].setDiffuseColor(RichPrimitiveFactoryJFX.translucentColor(Color.WHITE));
                ++i;
            }
        }
    }

    public boolean isTexturesOn() {
        return this.texturesOn;
    }

    public Image[] getTextures() {
        return this.timg;
    }

    public Image getTexture(int rank) {
        return this.timg[this.tidx[rank]];
    }

    private void loadTextures() {
        String[] files = new String[]{"cross1", "tllines", "rlines", "thlines", "tvlines", "dots1", "vlines", "hlines", "llines"};
        this.timg = new Image[files.length];
        File f = new File(this.textureDir);
        if (f.isDirectory()) {
            int i = 0;
            while (i < files.length) {
                this.timg[i] = new Image(new File(f, String.valueOf(files[i]) + ".jpg").getAbsolutePath());
                ++i;
            }
        } else {
            ClassLoader cl = this.getClass().getClassLoader();
            int i = 0;
            while (i < files.length) {
                this.timg[i] = new Image(cl.getResourceAsStream(String.valueOf(this.textureDir) + "/" + files[i] + ".jpg"));
                ++i;
            }
        }
        this.tidx = new int[this.timg.length];
        int i = 0;
        while (i < this.tidx.length) {
            this.tidx[i] = i;
            ++i;
        }
    }

    public void setAppearances(int nbc) {
        int base = 6;
        this.nbColor = nbc % base != 0 ? (nbc / base + 1) * 6 : nbc;
        this.tabColor = new Color[this.nbColor];
        this.tabMat = new PhongMaterial[this.nbColor];
        this.selectTabMat = new PhongMaterial[this.nbColor];
        this.translucentTabMat = new PhongMaterial[this.nbColor];
        float x = 0.0f;
        float y = 0.0f;
        float z = 1.0f;
        float step = this.nbColor / base;
        int i = 0;
        while (i < this.nbColor) {
            if (nbc < base && i == 1) {
                x = 1.0f;
                y = 0.0f;
                z = 0.0f;
            }
            if (nbc < base && i == 2) {
                x = 0.0f;
                y = 1.0f;
                z = 0.0f;
            }
            if (nbc < base && i == 3) {
                x = 0.0f;
                y = 1.0f;
                z = 1.0f;
            }
            if (nbc < base && i == 4) {
                x = 1.0f;
                y = 1.0f;
                z = 0.0f;
            }
            if (nbc < base && i == 5) {
                x = 1.0f;
                y = 0.0f;
                z = 1.0f;
            }
            if (nbc < base && i == 6) {
                x = 1.0f;
                y = 1.0f;
                z = 1.0f;
            }
            float xprime = x;
            float yprime = y;
            float zprime = z;
            this.tabColor[i] = new Color((double)xprime, (double)yprime, (double)zprime, 1.0);
            this.tabMat[i] = RichPrimitiveFactoryJFX.createBasicAppearance(this.tabColor[i]);
            this.selectTabMat[i] = RichPrimitiveFactoryJFX.createSelectedAppearance(this.tabColor[i]);
            this.translucentTabMat[i] = RichPrimitiveFactoryJFX.createTranslucentAppearance(this.tabColor[i]);
            switch ((int)((float)i / step)) {
                case 0: {
                    y += 1.0f / step;
                    y = Math.min(y, 1.0f);
                    break;
                }
                case 1: {
                    z -= 1.0f / step;
                    z = Math.max(z, 0.0f);
                    break;
                }
                case 2: {
                    x += 1.0f / step;
                    x = Math.min(x, 1.0f);
                    break;
                }
                case 3: {
                    y -= 1.0f / step;
                    y = Math.max(y, 0.0f);
                    break;
                }
                case 4: {
                    z += 1.0f / step;
                    z = Math.min(z, 1.0f);
                    break;
                }
                case 5: {
                    x -= 1.0f / step;
                    x = Math.max(x, 0.0f);
                }
            }
            ++i;
        }
        if (this.texturesOn) {
            this.setTextures();
        }
    }

    public void setAppearance(Color[] tab) {
        if (this.tabColor == null || this.tabColor.length != tab.length) {
            this.tabColor = new Color[tab.length];
        }
        int i = 0;
        while (i < tab.length) {
            this.setAppearance(i, tab[i]);
            ++i;
        }
    }

    public void setContinuous(float min, float max, Color cMin, Color cMax) {
        this.minValue = min;
        this.maxValue = max;
        this.minColor = cMin != null ? cMin : DEFAULT_MIN_COLOR;
        this.maxColor = cMax != null ? cMax : DEFAULT_MAX_COLOR;
        this.initSteps();
    }

    public Color getMinColor() {
        return this.minColor;
    }

    public Color getMaxColor() {
        return this.maxColor;
    }

    private void initSteps() {
        this.stepR = (float)(this.maxColor.getRed() - this.minColor.getRed()) / (this.maxValue - this.minValue);
        this.stepG = (float)(this.maxColor.getGreen() - this.minColor.getGreen()) / (this.maxValue - this.minValue);
        this.stepB = (float)(this.maxColor.getBlue() - this.minColor.getBlue()) / (this.maxValue - this.minValue);
    }

    public PhongMaterial getAppearance(float value) {
        Color appCol;
        if (value <= this.minValue) {
            appCol = this.minColor;
        } else if (value >= this.maxValue) {
            appCol = this.maxColor;
        } else {
            float dist = value - this.minValue;
            float r = (float)(this.minColor.getRed() + (double)(dist * this.stepR));
            float g = (float)(this.minColor.getGreen() + (double)(dist * this.stepG));
            float b = (float)(this.minColor.getBlue() + (double)(dist * this.stepB));
            appCol = new Color((double)r, (double)g, (double)b, 1.0);
        }
        PhongMaterial pm = new PhongMaterial();
        pm.setDiffuseColor(appCol);
        pm.setSpecularColor(Color.DARKGREY);
        pm.setSpecularPower(1024.0);
        return pm;
    }

    public int getNbColor() {
        return this.nbColor;
    }

    public Color[] getTabColor() {
        Color[] res = new Color[this.nbColor];
        int i = 0;
        while (i < this.nbColor) {
            res[i] = this.tabColor[i];
            ++i;
        }
        return res;
    }

    public void setAppearance(int rank, Color col) {
        this.tabColor[rank] = col;
        this.tabMat[rank].setDiffuseColor(col);
        this.selectTabMat[rank].setDiffuseColor(col);
        this.translucentTabMat[rank].setDiffuseColor(RichPrimitiveFactoryJFX.translucentColor(col));
    }

    public void setAppearance(int rank, boolean transp) {
        Color dc = this.tabColor[rank];
        if (dc.isOpaque() == transp) {
            Color newdc;
            this.tabColor[rank] = newdc = new Color(dc.getRed(), dc.getGreen(), dc.getBlue(), (double)(transp ? 0.0f : 1.0f));
            this.tabMat[rank].setDiffuseColor(newdc);
            this.selectTabMat[rank].setDiffuseColor(newdc);
        }
    }

    private static PhongMaterial createBasicAppearance(Color col) {
        PhongMaterial pm = new PhongMaterial();
        pm.setDiffuseColor(col);
        pm.setSpecularColor(Color.DARKGRAY);
        pm.setSpecularPower(128.0);
        return pm;
    }

    private static PhongMaterial createSelectedAppearance(Color col) {
        PhongMaterial pm = new PhongMaterial();
        pm.setDiffuseColor(col);
        pm.setSpecularColor(Color.WHITE);
        pm.setSpecularPower(1.0);
        return pm;
    }

    private static PhongMaterial createTranslucentAppearance(Color col) {
        PhongMaterial pm = new PhongMaterial();
        pm.setDiffuseColor(RichPrimitiveFactoryJFX.translucentColor(col));
        pm.setSpecularColor(RichPrimitiveFactoryJFX.translucentColor(Color.WHITE));
        pm.setSpecularPower(1024.0);
        return pm;
    }

    public PhongMaterial getAppearance(int numMat, boolean selected) {
        if (selected) {
            return this.selectTabMat[numMat];
        }
        return this.tabMat[numMat];
    }

    public PhongMaterial getSelectedAppearance(int numApp) {
        return this.selectTabMat[numApp];
    }

    public PhongMaterial getBasicAppearance(int numApp) {
        return this.tabMat[numApp];
    }

    public PhongMaterial getTranslucentAppearance(int numApp) {
        return this.translucentTabMat[numApp];
    }

    public PhongMaterial getCropMaterial() {
        return this.cropMaterial;
    }

    public int getRank(Color c) {
        int i = 0;
        while (i < this.nbColor) {
            if (this.tabColor[i].equals((Object)c)) {
                return i;
            }
            ++i;
        }
        this.addColor(c);
        this.tabColor[i] = c;
        this.setAppearance(i, c);
        return i;
    }

    private void addColor(Color col) {
        ++this.nbColor;
        this.tabColor = Arrays.copyOf(this.tabColor, this.nbColor);
        this.tabMat = Arrays.copyOf(this.tabMat, this.nbColor);
        this.selectTabMat = Arrays.copyOf(this.selectTabMat, this.nbColor);
        this.translucentTabMat = Arrays.copyOf(this.translucentTabMat, this.nbColor);
        this.tabColor[this.nbColor - 1] = col;
        this.tabMat[this.nbColor - 1] = RichPrimitiveFactoryJFX.createBasicAppearance(col);
        this.selectTabMat[this.nbColor - 1] = RichPrimitiveFactoryJFX.createSelectedAppearance(col);
        this.translucentTabMat[this.nbColor - 1] = RichPrimitiveFactoryJFX.createTranslucentAppearance(col);
    }

    public PhongMaterial getAppearance(Color c) {
        int i = this.getRank(c);
        return this.tabMat[i];
    }

    public PhongMaterial getAppearance(Color c, boolean select) {
        return this.getAppearance(this.getRank(c), select);
    }

    public PhongMaterial flipAppearance(PhongMaterial app) {
        int i = this.getRank(RichPrimitiveFactoryJFX.getColor(app));
        if (this.tabMat[i].equals(app)) {
            return this.selectTabMat[i];
        }
        return this.tabMat[i];
    }

    public static Color getColor(PhongMaterial mat) {
        return mat.getDiffuseColor();
    }

    public PhongMaterial getAppearance(PhongMaterial app, boolean select) {
        return this.getAppearance(RichPrimitiveFactoryJFX.getColor(app), select);
    }

    public PhongMaterial getDefaultAppearance(boolean sel) {
        if (!sel) {
            return this.tabMat[0];
        }
        return this.selectTabMat[1];
    }

    public void setTexture(int rank, int txtidx) {
    }

    private static Color translucentColor(Color c) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), (double)0.1f);
    }

    public Material getPlaneMaterial() {
        return this.planeMaterial;
    }
}

