/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.w2d;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lib3d4j.display3D.Display;
import lib3d4j.display3D.java3D.CentralSelection;
import lib3d4j.display3D.java3D.CentralSelectionObserver;
import lib3d4j.international.Messages;
import lib3d4j.w2d.ImageDisplayerException;
import lib3d4j.w2d.ImagePanel;

public class ImageDisplayer
extends JFrame
implements CentralSelectionObserver {
    private static final long serialVersionUID = 1L;
    private static ImageDisplayer imgd = new ImageDisplayer(10, 10);
    private int dim = 600;
    private int gridWidth = 4;
    private GridLayout gl = null;
    protected JPanel topPanel = null;
    protected HashMap<Integer, HashMap<URL, ImagePanel>> hmi = null;
    protected Display display = null;
    private CentralSelection cs = null;
    protected MouseListener ml = null;

    public ImageDisplayer(int x, int y) {
        super(Messages.getString("imgdisp_title"));
        this.setLocation(new Point(x, y));
        this.setSize(this.dim, this.dim);
        this.topPanel = new JPanel();
        this.gl = new GridLayout(0, this.gridWidth);
        this.topPanel.setLayout(this.gl);
        JScrollPane jsp = new JScrollPane(this.topPanel);
        this.add((Component)jsp, "Center");
        this.hmi = new HashMap();
        this.ml = new ImgDispMouseListener();
        this.addMouseListener(this.ml);
        this.pack();
        this.cs = CentralSelection.getSingleton();
        this.cs.reference(this);
    }

    public static ImageDisplayer getImageDisplayer() {
        return imgd;
    }

    @Override
    public void dispose() {
        this.cs.dereference(this);
        super.dispose();
    }

    public ImagePanel addImage(String title, URL u, String fileName, int id) throws ImageDisplayerException {
        ImagePanel imagePanel;
        HashMap<URL, ImagePanel> hms = this.hmi.get(id);
        if (hms == null) {
            hms = new HashMap();
            this.hmi.put(id, hms);
        }
        if ((imagePanel = hms.get(u)) == null) {
            imagePanel = this.createPanel(u, title, id);
            hms.put(u, imagePanel);
            if (this.cs.isSelected(id)) {
                imagePanel.setSelected(true);
            }
        }
        this.setVisible(true);
        return imagePanel;
    }

    public ImagePanel addImage(String title, URL u, int id) throws ImageDisplayerException {
        ImagePanel imagePanel;
        HashMap<URL, ImagePanel> hms = this.hmi.get(id);
        if (hms == null) {
            hms = new HashMap();
            this.hmi.put(id, hms);
        }
        if ((imagePanel = hms.get(u)) == null) {
            imagePanel = this.createPanel(u, title, id);
            hms.put(u, imagePanel);
            if (this.cs.isSelected(id)) {
                imagePanel.setSelected(true);
            }
        }
        this.setVisible(true);
        return imagePanel;
    }

    private ImagePanel createPanel(URL u, String title, int id) {
        Image image = Toolkit.getDefaultToolkit().getImage(u);
        image = new ImageIcon(image).getImage();
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        float scale = (float)this.dim / (float)(Math.max(w, h) * this.gridWidth);
        w = (int)((float)w * scale);
        h = (int)((float)h * scale);
        ImagePanel imagePanel = new ImagePanel(image, w, h, title, id, this.ml);
        this.topPanel.add(imagePanel);
        this.pack();
        return imagePanel;
    }

    public void removeImages() {
        for (HashMap<URL, ImagePanel> hms : this.hmi.values()) {
            for (ImagePanel imp : hms.values()) {
                this.topPanel.remove(imp);
            }
        }
        this.hmi.clear();
        this.setVisible(false);
    }

    public void removeImage(int id, URL u) {
        ImagePanel imagePanel;
        HashMap<URL, ImagePanel> hms = this.hmi.get(id);
        if (hms != null && (imagePanel = hms.get(u)) != null) {
            this.topPanel.remove(imagePanel);
            this.pack();
            hms.remove(u);
            if (hms.isEmpty()) {
                this.hmi.remove(id);
            }
            if (this.hmi.isEmpty()) {
                this.setVisible(false);
            }
        }
    }

    public void setSelectCallback(Display d) {
        this.display = d;
    }

    @Override
    public void selectionStateChanged(int index) {
        this.cs.flipState(index, this);
    }

    @Override
    public void onSelectionChange() {
        boolean[] lesObjetsSelect = this.cs.getSelectStates();
        Set<Integer> s = this.hmi.keySet();
        for (int index : s) {
            for (ImagePanel imp : this.hmi.get(index).values()) {
                imp.setSelected(lesObjetsSelect[index]);
            }
        }
    }

    protected class ImgDispMouseListener
    extends MouseAdapter {
        protected ImgDispMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ImagePanel ip;
            ip.setSelected(!(ip = (ImagePanel)e.getSource()).getSelected());
            if (ImageDisplayer.this.display != null) {
                ImageDisplayer.this.selectionStateChanged(ip.getId());
            }
        }
    }
}

