/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.w2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lib3d4j.w2d.InnerPanel;

public class ImagePanel
extends JPanel {
    static Color standardBgColor = Color.lightGray;
    static Color standardBorderColor = Color.darkGray;
    static Color selectedColor = Color.red;
    static Border standardBorder = BorderFactory.createLineBorder(standardBorderColor, 1);
    static Border selectedBorder = BorderFactory.createLineBorder(selectedColor, 1);
    private static final long serialVersionUID = 1L;
    protected int id;
    private boolean selected = false;
    protected InnerPanel inPanel;

    public ImagePanel(int w, int h) {
        this.setLayout(new BorderLayout());
        this.setBackground(standardBgColor);
        this.setBorder(standardBorder);
    }

    public ImagePanel(Image image, int w, int h) {
        this(w, h);
        this.inPanel = new InnerPanel(image, w, h, this);
        this.add((Component)this.inPanel, "Center");
    }

    public ImagePanel(Image image, int w, int h, String title) {
        this(w, h);
        this.inPanel = new InnerPanel(image, w, h, title, this);
        this.add((Component)this.inPanel, "Center");
        this.add((Component)new JLabel(title, 0), "South");
    }

    public ImagePanel(Image image, int w, int h, String title, int id, MouseListener ml) {
        this(image, w, h, title);
        this.id = id;
        this.addMouseListener(ml);
    }

    public int getId() {
        return this.id;
    }

    public void drag(boolean b) {
        System.out.println(this.id);
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        if (b != this.selected) {
            this.selected = b;
            if (b) {
                this.setBackground(selectedColor);
                this.setBorder(selectedBorder);
            } else {
                this.setBackground(standardBgColor);
                this.setBorder(standardBorder);
            }
        }
    }
}

