/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.w2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import lib3d4j.data.DescriptionData;
import lib3d4j.display3D.javafx.JFXSwingUtils;
import lib3d4j.display3D.javafx.objects.RichPrimitiveFactoryJFX;
import lib3d4j.international.Messages;
import lib3d4j.w2d.BoxTransp;
import lib3d4j.w2d.JPanelLegend;
import lib3d4j.w2d.LDMouseAdapter;
import lib3d4j.w2d.LegendSquare;
import lib3d4j.w2d.LegendSquareListener;
import lib3d4j.w2d.Legendable;

public class JPanelLegendStandard
extends JPanelLegend
implements Scrollable {
    private static int SCROLLHEIGHT = 500;
    protected Point location;
    protected Legendable parent;
    protected BoxTransp[] boxPoints;
    protected BoxTransp[] boxEllipses;
    protected BoxTransp[] boxEnvelopes;
    protected String[] jlNames;
    protected int[] jlCards;
    protected int nbcats = 0;
    private JLabel jlTitleName;
    private JLabel jlTitleCard;
    private List<List<JComponent>> lines;
    DescriptionData dd;
    private JCheckBox jcbPointsAll;
    private JCheckBox jcbEllipsesAll;
    private JCheckBox jcbEnvelopesAll;
    private LegendSquare[] legendSquares;
    private RichPrimitiveFactoryJFX rpf = RichPrimitiveFactoryJFX.getFactory();

    public JPanelLegendStandard(List<Object> cats, Legendable f3d, DescriptionData dd) {
        this(new GridBagLayout());
        Color[] colors = JFXSwingUtils.toAwtColors(this.rpf.getTabColor());
        BufferedImage[] textures = null;
        if (this.rpf.isTexturesOn()) {
            textures = JFXSwingUtils.toAwtImages(this.rpf.getTextures());
        }
        this.init(colors, cats, f3d, dd, textures);
    }

    public JPanelLegendStandard(LayoutManager layout) {
        super(layout);
    }

    public void reset(List<Object> cats, Legendable f3d, DescriptionData dd) {
        this.lines = null;
        this.cleanBoxes();
        this.removeAll();
        Color[] colors = JFXSwingUtils.toAwtColors(this.rpf.getTabColor());
        BufferedImage[] textures = null;
        if (this.rpf.isTexturesOn()) {
            textures = JFXSwingUtils.toAwtImages(this.rpf.getTextures());
        }
        this.init(colors, cats, f3d, dd, textures);
        if (this.jdialog != null) {
            this.jdialog.pack();
        }
    }

    protected void init(Color[] colors, List<Object> cats, Legendable f3d, DescriptionData dd, BufferedImage[] textures) {
        this.parent = f3d;
        this.dd = dd;
        this.nbcats = cats.size();
        JLabel jlVisu = new JLabel(Messages.getString("legend_view"));
        this.add(jlVisu, 0, 0, 3);
        this.add(new JLabel("      "), 3, 0, 1, this.nbcats + 2);
        JLabel jlAttr = new JLabel(Messages.getString("legend_attr"));
        this.add(jlAttr, 4, 0, 2);
        LDMouseAdapter ldma = new LDMouseAdapter(this);
        LegendSquareListener ftr = new LegendSquareListener(this, this);
        this.boxPoints = new BoxTransp[this.nbcats];
        this.boxEllipses = new BoxTransp[this.nbcats];
        this.boxEnvelopes = new BoxTransp[this.nbcats];
        this.legendSquares = new LegendSquare[this.nbcats];
        this.jlNames = new String[this.nbcats];
        this.jlCards = new int[this.nbcats];
        this.lines = new ArrayList<List<JComponent>>();
        this.add((Component)new JLabel(Messages.getString("legend_view_classes")), 0, 1);
        this.add((Component)new JLabel(Messages.getString("legend_view_ellipsoid")), 1, 1);
        this.add((Component)new JLabel(Messages.getString("legend_view_envelope")), 2, 1);
        this.add((Component)new JLabel(Messages.getString("legend_color")), 3, 1);
        this.jlTitleName = new JLabel(Messages.getString("legend_attr_val"));
        this.add((Component)this.jlTitleName, 5, 1);
        this.jlTitleCard = new JLabel(Messages.getString("legend_attr_card"));
        this.add((Component)this.jlTitleCard, 6, 1);
        ReorderMouseListener rml = new ReorderMouseListener();
        this.jlTitleName.addMouseListener(rml);
        this.jlTitleCard.addMouseListener(rml);
        ShowHideActionListener shal = new ShowHideActionListener();
        this.jcbPointsAll = new JCheckBox();
        this.jcbPointsAll.setToolTipText(Messages.getString("legend_show_hide_all"));
        this.jcbPointsAll.setBackground(Color.BLUE);
        this.jcbPointsAll.setSelected(true);
        this.jcbPointsAll.addActionListener(shal);
        this.add((Component)this.jcbPointsAll, 0, 2);
        this.jcbEllipsesAll = new JCheckBox();
        this.jcbEllipsesAll.setToolTipText(Messages.getString("legend_show_hide_all"));
        this.jcbEllipsesAll.setBackground(Color.BLUE);
        this.jcbEllipsesAll.setSelected(false);
        this.jcbEllipsesAll.addActionListener(shal);
        this.add((Component)this.jcbEllipsesAll, 1, 2);
        this.jcbEnvelopesAll = new JCheckBox();
        this.jcbEnvelopesAll.setToolTipText(Messages.getString("legend_show_hide_all"));
        this.jcbEnvelopesAll.setBackground(Color.BLUE);
        this.jcbEnvelopesAll.setSelected(false);
        this.jcbEnvelopesAll.addActionListener(shal);
        this.add((Component)this.jcbEnvelopesAll, 2, 2);
        int i = 0;
        while (i < this.nbcats) {
            ArrayList<JComponent> lineComp = new ArrayList<JComponent>();
            int line = i + 3;
            BoxTransp box = new BoxTransp(i, 0);
            box.addActionListener(ftr);
            this.add((Component)box, 0, line);
            this.boxPoints[i] = box;
            lineComp.add(box);
            BoxTransp box2 = new BoxTransp(i, 1, false);
            box2.addActionListener(ftr);
            this.add((Component)box2, 1, line);
            this.boxEllipses[i] = box2;
            lineComp.add(box2);
            BoxTransp box3 = new BoxTransp(i, 2, false);
            box3.addActionListener(ftr);
            this.add((Component)box3, 2, line);
            this.boxEnvelopes[i] = box3;
            lineComp.add(box3);
            LegendSquare jlc = textures == null ? new LegendSquare(i, colors[i]) : new LegendSquare(i, colors[i], textures[i]);
            this.add((Component)jlc, 3, line);
            jlc.addMouseListener(ldma);
            this.legendSquares[i] = jlc;
            lineComp.add(jlc);
            JLabel jlName = new JLabel(cats.get(i).toString());
            this.add((Component)jlName, 5, line);
            lineComp.add(jlName);
            this.jlNames[i] = cats.get(i).toString();
            JLabel jlCard = new JLabel(Integer.toString(dd.getGroupCardinality(1, i)));
            this.add((Component)jlCard, 6, line);
            lineComp.add(jlCard);
            this.jlCards[i] = dd.getGroupCardinality(1, i);
            this.lines.add(lineComp);
            ++i;
        }
    }

    @Override
    protected JFrame createDialog(String title) {
        this.jdialog = new JPanelLegend.DelayedJFrame(this);
        this.jdialog.setDefaultCloseOperation(0);
        this.jdialog.setTitle(title);
        JScrollPane jsp = new JScrollPane(this, 20, 31);
        this.jdialog.add(jsp);
        this.jdialog.pack();
        return this.jdialog;
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            this.cleanBoxes();
            this.dispose();
        }
        super.setVisible(b);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension d = this.getPreferredSize();
        if (d.height > SCROLLHEIGHT) {
            d.height = SCROLLHEIGHT;
        }
        return d;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public void cleanBoxes() {
        BoxTransp box;
        BoxTransp[] boxTranspArray = this.boxEllipses;
        int n = this.boxEllipses.length;
        int n2 = 0;
        while (n2 < n) {
            box = boxTranspArray[n2];
            if (box.isSelected()) {
                box.doClick(1);
            }
            ++n2;
        }
        boxTranspArray = this.boxEnvelopes;
        n = this.boxEnvelopes.length;
        n2 = 0;
        while (n2 < n) {
            box = boxTranspArray[n2];
            if (box.isSelected()) {
                box.doClick(1);
            }
            ++n2;
        }
    }

    protected void dispose() {
        this.parent.setAllVisible(true);
        this.parent.desuroundAll();
    }

    public void updateColor(int r, Color c) {
        this.rpf.setAppearance(r, JFXSwingUtils.toJFXColor(c));
        this.parent.setGroupColor(r, JFXSwingUtils.toJFXColor(c));
        if (this.boxEllipses[r].isSelected()) {
            this.boxEllipses[r].doClick(1);
            this.boxEllipses[r].doClick(1);
        }
        if (this.boxEnvelopes[r].isSelected()) {
            this.boxEnvelopes[r].doClick(1);
            this.boxEnvelopes[r].doClick(1);
        }
    }

    public void setGroupTransparency(int r, boolean transp) {
        this.parent.setGroupVisible(r, transp);
    }

    public void setEllipseAfficher(int r, boolean visible) {
        if (this.boxEllipses[r].isSelected() != visible) {
            this.boxEllipses[r].doClick();
        }
    }

    public void setPointsAfficher(int r, boolean visible) {
        if (this.boxPoints[r].isSelected() != visible) {
            this.boxPoints[r].doClick();
        }
    }

    protected void clean() {
        for (List<JComponent> l : this.lines) {
            for (JComponent c : l) {
                this.remove(c);
            }
        }
    }

    protected void add(Component c, int x, int y) {
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = x;
        g.gridy = y;
        g.ipadx = 5;
        g.ipady = 5;
        this.add(c, g);
    }

    protected void add(Component c, int x, int y, int width) {
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = x;
        g.gridy = y;
        g.gridwidth = width;
        g.ipadx = 5;
        g.ipady = 5;
        this.add(c, g);
    }

    protected void add(Component c, int x, int y, int width, int height) {
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = x;
        g.gridy = y;
        g.gridwidth = width;
        g.gridheight = height;
        g.ipadx = 5;
        g.ipady = 5;
        this.add(c, g);
    }

    public void setFunctionScript(String nomFonction, String[] lesParametres) {
        int index = Integer.parseInt(lesParametres[0]) - 1;
        boolean isSelected = Boolean.parseBoolean(lesParametres[1]);
        if (nomFonction.substring(3).equals(Messages.getString("legend_view_classes"))) {
            if (this.boxPoints[index].isSelected() && !isSelected || !this.boxPoints[index].isSelected() && isSelected) {
                this.boxPoints[index].doClick();
            }
        } else if (nomFonction.substring(3).equals(Messages.getString("legend_view_ellipsoid"))) {
            if (this.boxEllipses[index].isSelected() && !isSelected || !this.boxEllipses[index].isSelected() && isSelected) {
                this.boxEllipses[index].doClick();
            }
        } else if (nomFonction.substring(3).equals(Messages.getString("legend_view_envelope")) && (this.boxEnvelopes[index].isSelected() && !isSelected || !this.boxEnvelopes[index].isSelected() && isSelected)) {
            this.boxEnvelopes[index].doClick();
        }
    }

    public void updateTexture(int rank, int txtidx) {
        this.rpf.setTexture(rank, txtidx);
    }

    public void switchToTexture() {
        if (this.rpf.isTexturesOn()) {
            BufferedImage[] textures = JFXSwingUtils.toAwtImages(this.rpf.getTextures());
            int i = 0;
            while (i < this.nbcats) {
                this.legendSquares[i].setIcon(textures[i]);
                ++i;
            }
        }
    }

    public void switchToColors() {
        if (!this.rpf.isTexturesOn()) {
            int i = 0;
            while (i < this.nbcats) {
                this.legendSquares[i].setIcon((Icon)null);
                ++i;
            }
        }
    }

    class ReorderMouseListener
    extends MouseAdapter {
        ReorderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int cptorder;
            int j;
            int i;
            int[] order = new int[JPanelLegendStandard.this.nbcats];
            if (e.getSource().equals(JPanelLegendStandard.this.jlTitleName)) {
                ArrayList<String> names = new ArrayList<String>();
                i = 0;
                while (i < JPanelLegendStandard.this.nbcats) {
                    names.add(JPanelLegendStandard.this.jlNames[i]);
                    ++i;
                }
                Collections.sort(names);
                j = 0;
                while (j < JPanelLegendStandard.this.nbcats) {
                    cptorder = 0;
                    while (cptorder < names.size()) {
                        if (JPanelLegendStandard.this.jlNames[j] == names.get(cptorder)) {
                            order[cptorder] = j;
                            names.set(cptorder, null);
                            break;
                        }
                        ++cptorder;
                    }
                    ++j;
                }
            } else if (e.getSource().equals(JPanelLegendStandard.this.jlTitleCard)) {
                ArrayList<Integer> cards = new ArrayList<Integer>();
                i = 0;
                while (i < JPanelLegendStandard.this.nbcats) {
                    cards.add(JPanelLegendStandard.this.jlCards[i]);
                    ++i;
                }
                Collections.sort(cards);
                j = 0;
                while (j < JPanelLegendStandard.this.nbcats) {
                    cptorder = 0;
                    while (cptorder < cards.size()) {
                        if (JPanelLegendStandard.this.jlCards[j] == (Integer)cards.get(cptorder)) {
                            order[cptorder] = j;
                            cards.set(cptorder, -1);
                            break;
                        }
                        ++cptorder;
                    }
                    ++j;
                }
            }
            JPanelLegendStandard.this.clean();
            int i2 = 0;
            while (i2 < JPanelLegendStandard.this.nbcats) {
                int nl = i2 + 3;
                List l = (List)JPanelLegendStandard.this.lines.get(order[i2]);
                JPanelLegendStandard.this.add((Component)l.get(0), 0, nl);
                JPanelLegendStandard.this.add((Component)l.get(1), 1, nl);
                JPanelLegendStandard.this.add((Component)l.get(2), 2, nl);
                JPanelLegendStandard.this.add((Component)l.get(3), 3, nl);
                JPanelLegendStandard.this.add((Component)l.get(4), 5, nl);
                JPanelLegendStandard.this.add((Component)l.get(5), 6, nl);
                ++i2;
            }
            if (JPanelLegendStandard.this.jdialog != null) {
                JPanelLegendStandard.this.jdialog.pack();
            }
            JPanelLegendStandard.this.repaint();
        }
    }

    class ShowHideActionListener
    implements ActionListener {
        ShowHideActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            BoxTransp[] boxTab = null;
            if (source.equals(JPanelLegendStandard.this.jcbPointsAll)) {
                boxTab = JPanelLegendStandard.this.boxPoints;
            } else if (source.equals(JPanelLegendStandard.this.jcbEllipsesAll)) {
                boxTab = JPanelLegendStandard.this.boxEllipses;
            } else if (source.equals(JPanelLegendStandard.this.jcbEnvelopesAll)) {
                boxTab = JPanelLegendStandard.this.boxEnvelopes;
            } else {
                return;
            }
            boolean newstate = ((JCheckBox)source).isSelected();
            BoxTransp[] boxTranspArray = boxTab;
            int n = boxTab.length;
            int n2 = 0;
            while (n2 < n) {
                BoxTransp bt = boxTranspArray[n2];
                if (bt.isSelected() != newstate) {
                    bt.doClick();
                }
                ++n2;
            }
        }
    }
}

