/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.w2d;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import lib3d4j.display3D.javafx.SceneJFX;

public class Stage3D
extends Stage {
    private SceneJFX jp3d = null;
    protected static final int BORDER_SIZE = 3;
    protected static final BorderWidths bw = new BorderWidths(3.0);
    protected static final Color NOFOCUS = Color.BLACK;
    protected static final Color HASFOCUS = Color.RED;

    public Stage3D(SceneJFX jp3d, String title) {
        this.setTitle(title);
        this.jp3d = jp3d;
        this.setScene(jp3d.getScene());
    }

    public Stage3D(SceneJFX jp3d) {
        this(jp3d, "");
    }

    public void afterShow() {
        Stage3DResizeListener srl = new Stage3DResizeListener();
        this.getScene().widthProperty().addListener((ChangeListener)srl);
        this.getScene().heightProperty().addListener((ChangeListener)srl);
    }

    public void setLabel(String label) {
    }

    public void setHighlighted(boolean h) {
        Color c = h ? HASFOCUS : NOFOCUS;
        ((BorderPane)this.getScene().getRoot()).setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)c, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, bw)}));
    }

    public void proceedResize() {
        this.jp3d.resize(this.getScene().getWidth() - 6.0, this.getScene().getHeight() - 6.0);
    }

    class Stage3DResizeListener
    implements ChangeListener<Number> {
        Stage3DResizeListener() {
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            Stage3D.this.proceedResize();
        }
    }
}

